/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.logging;

public enum NBLogLevel {
    NONE(0L),
    FATAL(1L),
    ERROR(2L),
    WARN(4L),
    INFO(8L),
    DEBUG(16L),
    TRACE(32L),
    ALL(0x40000000L);

    private final long level;

    private NBLogLevel(long level) {
        this.level = level;
    }

    public static NBLogLevel valueOfName(String name) {
        for (NBLogLevel possible : NBLogLevel.values()) {
            if (!name.toUpperCase().equals(possible.toString())) continue;
            return possible;
        }
        throw new RuntimeException("Unable to find NBLogLevel for " + name);
    }

    public static NBLogLevel max(NBLogLevel ... levels) {
        NBLogLevel max = NONE;
        for (NBLogLevel level : levels) {
            if (level.level <= max.level) continue;
            max = level;
        }
        return max;
    }

    public boolean isGreaterOrEqualTo(NBLogLevel other) {
        return this.level >= other.level;
    }
}

