/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.aggregator;

import io.nosqlbench.nb.api.markdown.types.FrontMatterInfo;
import io.nosqlbench.nb.api.markdown.types.MarkdownInfo;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CompositeMarkdownInfo
implements MarkdownInfo {
    private final List<MarkdownInfo> elements = new LinkedList<MarkdownInfo>();
    private boolean isSorted = false;

    @Override
    public Path getPath() {
        return this.elements.get(0).getPath();
    }

    @Override
    public String getBody() {
        StringBuilder sb = new StringBuilder();
        if (!this.isSorted) {
            Collections.sort(this.elements);
            this.isSorted = true;
        }
        for (MarkdownInfo element : this.elements) {
            sb.append(element.getBody());
        }
        return sb.toString();
    }

    @Override
    public FrontMatterInfo getFrontmatter() {
        return this.elements.get(0).getFrontmatter();
    }

    @Override
    public boolean hasAggregations() {
        return false;
    }

    @Override
    public CompositeMarkdownInfo withTopics(List<String> assigning) {
        MarkdownInfo leader = this.elements.get(0);
        leader = leader.withTopics(assigning);
        this.elements.set(0, leader);
        return this;
    }

    @Override
    public CompositeMarkdownInfo withIncluded(List<String> included) {
        MarkdownInfo leader = this.elements.get(0);
        leader = leader.withIncluded(included);
        this.elements.set(0, leader);
        return this;
    }

    public <T extends MarkdownInfo> CompositeMarkdownInfo add(T element) {
        this.elements.add(element);
        this.isSorted = false;
        return this;
    }

    public String toString() {
        return "CompositeMarkdownInfo{elements=" + this.elements + ", isSorted=" + this.isSorted + "}";
    }
}

