/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.aggregator;

import io.nosqlbench.nb.api.markdown.aggregator.CompositeMarkdownInfo;
import io.nosqlbench.nb.api.markdown.types.MarkdownInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MDGraph {
    private Map<String, List<String>> topicsByPattern;
    private final Map<String, List<Edge<MarkdownInfo>>> elementsByPattern = new HashMap<String, List<Edge<MarkdownInfo>>>();
    private final Map<String, List<Edge<MarkdownInfo>>> elementsByTopic = new HashMap<String, List<Edge<MarkdownInfo>>>();
    private final List<Edge<MarkdownInfo>> elements = new LinkedList<Edge<MarkdownInfo>>();

    public void add(MarkdownInfo addingElem) {
        Edge<MarkdownInfo> edge = new Edge<MarkdownInfo>(addingElem);
        this.elements.add(edge);
        for (String topic : addingElem.getTopics()) {
            this.elementsByTopic.computeIfAbsent(topic, t -> new ArrayList()).add(edge);
        }
        if (addingElem.getTopics().size() == 0) {
            this.elementsByTopic.computeIfAbsent("none", t -> new ArrayList()).add(edge);
        }
        for (Pattern pattern : addingElem.getTopicGlobs()) {
            this.elementsByPattern.computeIfAbsent(pattern.pattern(), p -> new ArrayList()).add(edge);
        }
    }

    public List<MarkdownInfo> processed() {
        if (this.topicsByPattern == null) {
            this.topicsByPattern = this.topicsByPattern();
        }
        LinkedList<Edge<MarkdownInfo>> resolved = new LinkedList<Edge<MarkdownInfo>>(this.elements);
        ListIterator iter = resolved.listIterator();
        while (iter.hasNext()) {
            Edge elementEdge = (Edge)iter.next();
            Object element = elementEdge.get();
            List<Pattern> topicGlobs = element.getTopicGlobs();
            if (topicGlobs.size() == 0) continue;
            ArrayList<Edge<MarkdownInfo>> included = new ArrayList<Edge<MarkdownInfo>>();
            boolean leafnodes = true;
            for (Pattern topicGlob : topicGlobs) {
                for (String string : this.topicsByPattern.get(topicGlob.pattern())) {
                    List<Edge<MarkdownInfo>> edges = this.elementsByTopic.get(string);
                    for (Edge<MarkdownInfo> edge : edges) {
                        if (edge.get().getTopicGlobs().size() != 0) {
                            leafnodes = false;
                        }
                        included.add(edge);
                    }
                }
                if (leafnodes) {
                    CompositeMarkdownInfo mdinfo = new CompositeMarkdownInfo();
                    mdinfo.add(element);
                    for (Edge tEdge : included) {
                        mdinfo.add(tEdge.get());
                    }
                    MarkdownInfo markdownInfo = mdinfo.withTopics((List)element.getTopics());
                    elementEdge.set(markdownInfo);
                    continue;
                }
                iter.remove();
                resolved.addLast(elementEdge);
            }
        }
        return resolved.stream().map(Edge::get).collect(Collectors.toList());
    }

    private Map<String, List<String>> topicsByPattern() {
        HashMap<String, List<String>> tbp = new HashMap<String, List<String>>();
        for (String pattern : this.elementsByPattern.keySet()) {
            List matchingTopics = tbp.computeIfAbsent(pattern, p -> new ArrayList());
            for (String topic : this.elementsByTopic.keySet()) {
                if (!Pattern.compile(pattern).matcher(topic).matches()) continue;
                matchingTopics.add(topic);
            }
        }
        return tbp;
    }

    private static final class Edge<T extends MarkdownInfo> {
        private T element;

        public Edge(T element) {
            this.element = element;
        }

        public T get() {
            return this.element;
        }

        public void set(T element) {
            this.element = element;
        }
    }
}

