/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.aggregator;

import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.markdown.aggregator.ListSplitterWhyDoesJavaNotDoThisAlready;
import io.nosqlbench.nb.api.markdown.aggregator.MDGraph;
import io.nosqlbench.nb.api.markdown.aggregator.ParsedMarkdown;
import io.nosqlbench.nb.api.markdown.providers.RawMarkdownSources;
import io.nosqlbench.nb.api.markdown.types.Diagnostics;
import io.nosqlbench.nb.api.markdown.types.DocScope;
import io.nosqlbench.nb.api.markdown.types.FrontMatterInfo;
import io.nosqlbench.nb.api.markdown.types.MarkdownInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarkdownDocs {
    private static final Logger logger = LogManager.getLogger(MarkdownDocs.class);

    public static List<MarkdownInfo> find(DocScope ... scopes) {
        return MarkdownDocs.find(".*", scopes);
    }

    public static List<MarkdownInfo> findAll() {
        return MarkdownDocs.find(DocScope.ANY);
    }

    public static List<MarkdownInfo> find(String name, DocScope ... scopes) {
        List<Content<?>> markdownContent = RawMarkdownSources.getAllMarkdown();
        List<MarkdownInfo> markdownInfos = markdownContent.stream().map(ParsedMarkdown::new).collect(Collectors.toList());
        ArrayList diagBuffer = new ArrayList();
        markdownInfos.forEach(i -> Diagnostics.getDiagnostics(i, diagBuffer));
        diagBuffer.forEach(arg_0 -> ((Logger)logger).warn(arg_0));
        List topicSets = markdownInfos.stream().map(m -> m.getFrontmatter().getTopics()).collect(Collectors.toList());
        List nonGlobTopics = markdownInfos.stream().map(MarkdownInfo::getFrontmatter).map(FrontMatterInfo::getTopics).flatMap(Collection::stream).filter(s -> !MarkdownDocs.isPattern(s)).collect(Collectors.toList());
        List<MarkdownInfo> markdownWithTopicGlobs = ListSplitterWhyDoesJavaNotDoThisAlready.partition(markdownInfos, MarkdownInfo::hasTopicGlobs);
        List<MarkdownInfo> markdownWithOnlyTopicGlobs = ListSplitterWhyDoesJavaNotDoThisAlready.partition(markdownWithTopicGlobs, m -> m.getTopics().size() == 0);
        ArrayList<MarkdownInfo> ordered = new ArrayList<MarkdownInfo>();
        ordered.addAll(markdownWithOnlyTopicGlobs);
        ordered.addAll(markdownWithTopicGlobs);
        ordered.addAll(markdownInfos);
        MDGraph mdgraph = new MDGraph();
        ordered.forEach(mdgraph::add);
        return mdgraph.processed();
    }

    private static boolean isPattern(String srcTopic) {
        return srcTopic.startsWith("^") || srcTopic.contains(".*") || srcTopic.contains(".+") || srcTopic.endsWith("$");
    }

    private static class Edge<T> {
        private final int from;
        private final int to;
        private final T edgeProps;

        public Edge(int from, int to, Supplier<T> forT) {
            this.from = from;
            this.to = to;
            this.edgeProps = forT.get();
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }

        public T props() {
            return this.edgeProps;
        }
    }
}

