/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.aggregator;

import io.nosqlbench.nb.api.markdown.types.DocScope;
import io.nosqlbench.nb.api.markdown.types.FrontMatterInfo;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParsedFrontMatter
implements FrontMatterInfo {
    private static final Logger logger = LogManager.getLogger(ParsedFrontMatter.class);
    private final Map<String, List<String>> data;

    public ParsedFrontMatter(Map<String, List<String>> data) {
        this.data = data;
    }

    @Override
    public String getTitle() {
        List<String> titles = this.data.get("title");
        if (titles == null) {
            return "";
        }
        if (titles.size() != 1) {
            throw new InvalidParameterException("title can only contain a single value.");
        }
        return titles.get(0);
    }

    @Override
    public int getWeight() {
        List<String> weights = this.data.get("weight");
        if (weights == null) {
            return 0;
        }
        if (weights.size() != 1) {
            throw new InvalidParameterException("weight can only contain a single value.");
        }
        return Integer.parseInt(weights.get(0));
    }

    @Override
    public Set<String> getTopics() {
        List<String> topics = this.data.get("topics");
        HashSet<String> topicSet = new HashSet<String>();
        if (topics != null) {
            for (String topic : topics) {
                Collections.addAll(topicSet, topic.split(", *"));
            }
        }
        return topicSet;
    }

    @Override
    public List<String> getIncluded() {
        List<String> included = this.data.get("included");
        ArrayList<String> includedList = new ArrayList<String>();
        if (included != null) {
            for (String s : included) {
                Collections.addAll(includedList, s.split(", *"));
            }
        }
        return includedList;
    }

    @Override
    public List<Pattern> getAggregations() {
        if (!this.data.containsKey("aggregate")) {
            return List.of();
        }
        ArrayList patterns = new ArrayList();
        for (String aggName : this.data.get("aggregate")) {
            Collections.addAll(patterns, aggName.split(", *"));
        }
        return patterns.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @Override
    public Set<DocScope> getDocScopes() {
        if (!this.data.containsKey("scopes")) {
            return Set.of(DocScope.NONE);
        }
        ArrayList scopeNames = new ArrayList();
        for (String scopeName : this.data.get("scopes")) {
            Collections.addAll(scopeNames, scopeName.split(", *"));
        }
        return scopeNames.stream().map(DocScope::valueOf).collect(Collectors.toSet());
    }

    public List<String> getDiagnostics() {
        ArrayList<String> warnings = new ArrayList<String>();
        for (String propname : this.data.keySet()) {
            if (FrontMatterInfo.FrontMatterKeyWords.contains(propname)) continue;
            warnings.add("unrecognized frontm atter property " + propname);
        }
        return warnings;
    }

    public void setTopics(Set<String> newTopics) {
    }

    public ParsedFrontMatter withTopics(List<String> assigning) {
        HashMap<String, List<String>> newmap = new HashMap<String, List<String>>();
        newmap.putAll(this.data);
        newmap.put("topics", assigning);
        return new ParsedFrontMatter(newmap);
    }

    public ParsedFrontMatter withIncluded(List<String> included) {
        HashMap<String, List<String>> newmap = new HashMap<String, List<String>>();
        newmap.putAll(this.data);
        newmap.put("included", included);
        return new ParsedFrontMatter(newmap);
    }

    public String toString() {
        return "ParsedFrontMatter{data=" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedFrontMatter that = (ParsedFrontMatter)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

