/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.exporter;

import io.nosqlbench.nb.api.markdown.aggregator.MarkdownDocs;
import io.nosqlbench.nb.api.markdown.types.DocScope;
import io.nosqlbench.nb.api.markdown.types.MarkdownInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class MarkdownExporter
implements Runnable {
    public static final String APP_NAME = "exporter";
    private final Path basePath;
    private Set<DocScope> scopeSet;

    public MarkdownExporter(Path basePath, Set<DocScope> scopeSet) {
        this.basePath = basePath;
        this.scopeSet = scopeSet;
    }

    public static void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec basedir = parser.accepts("basedir", "base directory to write to").withRequiredArg().ofType(String.class).defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec docScopes = parser.accepts("scopes", "scopes of documentation to export").withRequiredArg().ofType(String.class).defaultsTo((Object)DocScope.ANY.toString(), (Object[])new String[0]);
        parser.acceptsAll(List.of("-h", "--help", "help"), "Display help").forHelp();
        OptionSet options = parser.parse(args);
        Path basePath = Path.of((String)basedir.value(options), new String[0]);
        Set<DocScope> scopeSet = docScopes.values(options).stream().map(DocScope::valueOf).collect(Collectors.toSet());
        new MarkdownExporter(basePath, scopeSet).run();
    }

    @Override
    public void run() {
        List<MarkdownInfo> markdownInfos = MarkdownDocs.find(new ArrayList<DocScope>(this.scopeSet).toArray(new DocScope[0]));
    }
}

