/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class SystemId {
    private static final Logger logger = LogManager.getLogger(SystemId.class);

    public static String getNodeId() {
        SystemInfo sysinfo = new SystemInfo();
        HardwareAbstractionLayer hal = sysinfo.getHardware();
        List interfaces = hal.getNetworkIFs();
        Optional<String> first = interfaces.stream().filter(i -> !i.getName().startsWith("docker")).filter(i -> !i.getName().equals("lo")).sorted((o1, o2) -> {
            if (o1.getName().startsWith("e") && o2.getName().startsWith("e")) {
                return 0;
            }
            if (o1.getName().startsWith("e")) {
                return -1;
            }
            if (o2.getName().startsWith("e")) {
                return 1;
            }
            return 0;
        }).flatMap(iface -> Arrays.stream((String[])iface.getIPv4addr().clone())).filter(addr -> !addr.startsWith("127.")).findFirst();
        String systemID = first.orElse("UNKNOWN_SYSTEM_ID");
        return systemID;
    }

    public static String getNodeFingerprint() {
        String addrId = SystemId.getNodeId();
        try {
            MessageDigest sha1_digest = MessageDigest.getInstance("SHA-1");
            byte[] addrBytes = sha1_digest.digest(addrId.getBytes(StandardCharsets.UTF_8));
            Object fingerprint = "";
            for (int i = 0; i < addrBytes.length; ++i) {
                fingerprint = (String)fingerprint + Integer.toString((addrBytes[i] & 0xFF) + 256, 16).substring(1);
            }
            return ((String)fingerprint).toUpperCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHostSummary() {
        SystemInfo sysinfo = null;
        HardwareAbstractionLayer hal = null;
        try {
            sysinfo = new SystemInfo();
            hal = sysinfo.getHardware();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(Map.of("ERROR", "OSHI library was unable to query system hardware details because: " + e.toString()));
        }
        HardwareSummary summary = new HardwareSummary(hal);
        summary.add("physical-cores", h -> {
            CentralProcessor p = h.getProcessor();
            return String.valueOf(p.getPhysicalProcessorCount());
        });
        summary.add("logical-cores", h -> {
            CentralProcessor p = h.getProcessor();
            return String.valueOf(p.getLogicalProcessors().size());
        });
        summary.add("max-frequency-ghz", h -> {
            CentralProcessor p = h.getProcessor();
            return String.format("%.2f", (double)p.getMaxFreq() / 1.0E12);
        });
        summary.add("sockets", h -> {
            CentralProcessor p = h.getProcessor();
            return String.valueOf(p.getPhysicalPackageCount());
        });
        summary.add("processor-name", h -> {
            CentralProcessor p = h.getProcessor();
            return String.valueOf(p.getProcessorIdentifier().getName());
        });
        summary.add("memory-GiB", h -> String.format("%.2f", (double)h.getMemory().getTotal() / 1.073741824E9));
        summary.add("heap-max-GiB", h -> String.format("%.2f", (double)Runtime.getRuntime().maxMemory() / 1.073741824E9));
        summary.add("if-speeds", h -> {
            HashSet ifspeeds = new HashSet();
            h.getNetworkIFs().forEach(x -> {
                long spd = x.getSpeed();
                if (spd < 1048576000L) {
                    ifspeeds.add(String.format("%.0fMib", spd / 0x100000L));
                } else {
                    ifspeeds.add(String.format("%.0fGib", spd / 1048576000L));
                }
            });
            return ifspeeds;
        });
        return summary.toString();
    }

    private static class HardwareSummary {
        private final HardwareAbstractionLayer hal;
        private Map<String, Object> details = new LinkedHashMap<String, Object>();

        public HardwareSummary(HardwareAbstractionLayer hal) {
            this.hal = hal;
        }

        public void add(String name, Function<HardwareAbstractionLayer, Object> gatherer) {
            try {
                String result = gatherer.apply(this.hal).toString();
                this.details.put(name, result);
            }
            catch (Exception e) {
                this.details.put(name, "ERROR:" + e.toString());
            }
        }

        public String toString() {
            Gson gson = new GsonBuilder().create();
            return gson.toJson(this.details);
        }
    }
}

