/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.spi;

import io.nosqlbench.nb.annotations.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleServiceLoader<T> {
    private static final Logger logger = LogManager.getLogger((String)"SERVICESAPI");
    private final Class<? extends T> serviceType;

    public SimpleServiceLoader(Class<? extends T> serviceType) {
        this.serviceType = serviceType;
    }

    public Optional<T> get(String implName) {
        LinkedHashMap<String, ServiceLoader.Provider<T>> namedProviders = this.getNamedProviders(new Pattern[0]);
        ServiceLoader.Provider<T> providers = namedProviders.get(implName);
        return Optional.ofNullable(providers == null ? null : (Object)providers.get());
    }

    public T getOrThrow(String implName) {
        Optional<T> t = this.get(implName);
        return t.orElseThrow(() -> new RuntimeException(this.serviceType.getSimpleName() + " '" + implName + "' not found. Available types:" + this.getNamedProviders(new Pattern[0]).keySet().stream().collect(Collectors.joining(","))));
    }

    public Optional<T> getOptionally(String implName) {
        Optional<T> type = this.get(implName);
        return type;
    }

    public synchronized LinkedHashMap<String, ServiceLoader.Provider<? extends T>> getNamedProviders(Pattern ... includes) {
        ServiceLoader<T> loader = ServiceLoader.load(this.serviceType);
        List<Pattern> patterns = includes != null && includes.length > 0 ? Arrays.asList(includes) : List.of(Pattern.compile(".*"));
        LinkedHashMap providers = new LinkedHashMap();
        loader.stream().forEach(provider -> {
            logger.trace("loading provider: " + provider.type());
            Class type = provider.type();
            if (!type.isAnnotationPresent(Service.class)) {
                throw new RuntimeException("Annotator services must be annotated with distinct selectors\nsuch as @Service(Annotator.class,selector=\"myimpl42\")");
            }
            Service service = type.getAnnotation(Service.class);
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(service.selector()).matches()) continue;
                providers.put(service.selector(), (ServiceLoader.Provider)provider);
                break;
            }
        });
        return providers;
    }

    public List<String> getAllSelectors(Pattern ... patterns) {
        return new ArrayList<String>(this.getNamedProviders(patterns).keySet());
    }
}

