/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.testutils;

import io.nosqlbench.nb.api.testutils.Result;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class Perf
implements Iterable<Result> {
    private final String description;
    private List<Result> results = new ArrayList<Result>();

    public Perf(String description) {
        this.description = description;
    }

    public double[] getDeltas(Function<Result, Double> resultProperty) {
        double[] values = new double[this.results.size()];
        for (int i = 0; i < this.results.size(); ++i) {
            values[i] = i == 0 ? Double.NaN : resultProperty.apply(this.results.get(i)) - resultProperty.apply(this.results.get(i - 1));
        }
        return values;
    }

    public Perf add(Result result) {
        this.results.add(result);
        return this;
    }

    public Perf add(String description, long start, long end, long ops) {
        return this.add(new Result(description, start, end, ops));
    }

    public boolean isConverged(Function<Result, Double> resultProperty, double withinMargin, int count) {
        if (this.results.size() < count + 1) {
            return false;
        }
        double actualMargin = this.getMaximumDelta(resultProperty, count);
        return actualMargin < withinMargin;
    }

    public double getMaximumDelta(Function<Result, Double> resultProperty, int count) {
        if (this.results.size() < count + 1) {
            return Double.NaN;
        }
        double[] values = this.results.stream().skip(this.results.size() - count).map(resultProperty).mapToDouble(Double::doubleValue).toArray();
        double min = DoubleStream.of(values).min().orElse(Double.MAX_VALUE);
        double max = DoubleStream.of(values).max().orElse(Double.MIN_VALUE);
        return (max - min) / max;
    }

    public Perf sort(Function<Result, Double> resultProperty) {
        this.results = this.results.stream().sorted(Comparator.comparing(resultProperty)).collect(Collectors.toList());
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.description + "\n");
        this.results.forEach(r -> {
            sb.append(r);
            sb.append("\n");
        });
        return sb.toString();
    }

    public String toStringDelta(Function<Result, Double> resultProperty, String deltaDescription, int ... lastN) {
        int count = lastN.length == 1 ? lastN[0] : this.results.size();
        double[] deltas = this.getDeltas(resultProperty);
        List pvalues = DoubleStream.of(deltas).mapToObj(v -> String.format("%-10.3f", v)).collect(Collectors.toList());
        List<String> rvalues = Result.toString(this.results);
        int maxlen = pvalues.stream().mapToInt(String::length).max().orElse(0);
        maxlen = Math.max(maxlen, deltaDescription.length());
        StringBuilder sb = new StringBuilder(String.format("iter %-" + maxlen + "s  %s\n", deltaDescription, this.description));
        String rowfmt = "%03d: %-" + maxlen + "s  %s\n";
        for (int i = 0; i < this.results.size(); ++i) {
            sb.append(String.format(rowfmt, i, pvalues.get(i), rvalues.get(i)));
        }
        return sb.toString();
    }

    public Result getLastResult() {
        return this.results.get(this.results.size() - 1);
    }

    public Perf reduceConcurrent() {
        long totalOps = this.results.stream().mapToLong(Result::getTotalOps).sum();
        double avgStart = this.results.stream().mapToLong(Result::getStartNanos).average().orElse(Double.NaN);
        double avgEnd = this.results.stream().mapToLong(Result::getEndNanos).average().orElse(Double.NaN);
        return new Perf("summary of \" + results.size() + \" concurrent results\"").add("summary of " + this.results.size() + " concurrent results", (long)avgStart, (long)avgEnd, totalOps);
    }

    @Override
    public Iterator<Result> iterator() {
        return this.results.iterator();
    }

    public Time start(String name, long ops) {
        return new Time(this, name, ops);
    }

    public static class Time
    implements AutoCloseable {
        private final Perf perf;
        private final long start;
        private String name;
        private long ops;

        public Time(Perf perf, String name, long ops) {
            this.name = name;
            this.ops = ops;
            this.start = System.nanoTime();
            this.perf = perf;
        }

        @Override
        public void close() {
            long end = System.nanoTime();
            this.perf.add(this.name, this.start, end, this.ops);
        }
    }
}

