/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.addins.s3.s3urlhandler;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.nosqlbench.addins.s3.s3urlhandler.S3UrlFields;
import java.util.WeakHashMap;

public class S3ClientCache {
    private final WeakHashMap<S3UrlFields.CredentialsFingerprint, AmazonS3> cache = new WeakHashMap();

    public AmazonS3 get(S3UrlFields fields) {
        AmazonS3 s3 = this.cache.computeIfAbsent(fields.getCredentialsFingerprint(), cfp -> this.createAuthorizedClient(fields));
        return s3;
    }

    private AmazonS3 createAuthorizedClient(S3UrlFields fields) {
        if (fields.accessKey != null && fields.secretKey != null) {
            AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
            BasicAWSCredentials specialcreds = new BasicAWSCredentials(fields.accessKey, fields.secretKey);
            builder = (AmazonS3ClientBuilder)builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)specialcreds));
            return (AmazonS3)builder.build();
        }
        return AmazonS3ClientBuilder.defaultClient();
    }
}

