/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.params;

import io.nosqlbench.api.config.params.ConfigSource;
import io.nosqlbench.api.config.params.ElementData;
import io.nosqlbench.api.config.params.JsonConfigSource;
import io.nosqlbench.api.config.params.ListBackedConfigSource;
import io.nosqlbench.api.config.params.MapBackedConfigSource;
import io.nosqlbench.api.config.params.ParamsParserSource;
import io.nosqlbench.api.content.NBIO;
import java.nio.file.Path;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSources {
    private static final Logger logger = LogManager.getLogger(DataSources.class);
    private static final List<ConfigSource> sources = List.of(new MapBackedConfigSource(), new JsonConfigSource(), new ParamsParserSource(), new ListBackedConfigSource());

    public static List<ElementData> elements(Object src) {
        return DataSources.elements(null, src);
    }

    public static List<ElementData> elements(String name, Object src) {
        if (src instanceof CharSequence && src.toString().startsWith("IMPORT{") && src.toString().endsWith("}")) {
            String data = src.toString();
            String filename = data.substring("IMPORT{".length(), data.length() - 1);
            Path filepath = Path.of(filename, new String[0]);
            src = NBIO.all().name(filename).first().map(c -> {
                logger.debug(() -> "found 'data' at " + c.getURI());
                return c.asString();
            }).orElseThrow();
        }
        if (src instanceof ElementData) {
            return List.of((ElementData)src);
        }
        for (ConfigSource source : sources) {
            if (!source.canRead(src)) continue;
            List<ElementData> elements = source.getAll(name, src);
            return elements;
        }
        throw new RuntimeException("Unable to find a config reader for source type " + src.getClass().getCanonicalName());
    }

    public static ElementData element(Object object) {
        return DataSources.element(null, object);
    }

    public static ElementData element(String name, Object object) {
        List<ElementData> elements = DataSources.elements(name, object);
        if (elements.size() != 1) {
            throw new RuntimeException("Expected exactly one object, but found " + elements.size());
        }
        return elements.get(0);
    }
}

