/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.params;

import io.nosqlbench.api.config.params.DataSources;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ElementData {
    public static final String NAME = "name";
    public static final List<Class<?>> COMMON_TYPES = List.of(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Map.class, Set.class, List.class);

    public static Optional<Object> asCommonType(Object src) {
        for (Class<?> commonType : COMMON_TYPES) {
            if (!commonType.isAssignableFrom(src.getClass())) continue;
            return Optional.of(commonType.cast(src));
        }
        return Optional.empty();
    }

    public Object get(String var1);

    public Set<String> getKeys();

    public boolean containsKey(String var1);

    default public String getName() {
        String name = this.getGivenName();
        if (name != null) {
            return name;
        }
        return this.extractElementName();
    }

    public String getGivenName();

    default public String extractElementName() {
        Object o;
        if (this.containsKey(NAME) && (o = this.get(NAME)) instanceof CharSequence) {
            return ((CharSequence)o).toString();
        }
        return null;
    }

    default public <T> T convert(Object input, Class<T> type) {
        if (type != null) {
            if (type.isAssignableFrom(input.getClass())) {
                return type.cast(input);
            }
            throw new RuntimeException("Conversion from " + input.getClass().getSimpleName() + " to " + type.getSimpleName() + " is not supported natively. You need to add a type converter to your ElementData implementation for " + this.getClass().getSimpleName());
        }
        return (T)input;
    }

    default public <T> T get(String name, Class<T> type) {
        Object o = this.get(name);
        if (o != null) {
            return this.convert(o, type);
        }
        return null;
    }

    default public <T> T lookup(String name, Class<T> type) {
        int idx = name.indexOf(46);
        while (idx > 0) {
            String parentName = name.substring(0, idx);
            if (this.containsKey(parentName)) {
                Object o = this.get(parentName);
                ElementData parentElement = DataSources.element(parentName, o);
                String childName = name.substring(idx + 1);
                int childidx = childName.indexOf(46);
                while (childidx > 0) {
                    String leaf;
                    ElementData branch;
                    T found;
                    String branchName = childName.substring(0, childidx);
                    T branchObject = parentElement.lookup(branchName, type);
                    if (branchObject != null && (found = (branch = DataSources.element(branchName, branchObject)).lookup(leaf = childName.substring(childidx + 1), type)) != null) {
                        return found;
                    }
                    childidx = childName.indexOf(46, childidx + 1);
                }
                T found = parentElement.lookup(childName, type);
                if (found != null) {
                    return found;
                }
            }
            idx = name.indexOf(46, idx + 1);
        }
        return this.get(name, type);
    }

    public Object getAsCommon(String var1);
}

