/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.params;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.nosqlbench.api.config.params.ElementData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;

public class JsonBackedConfigElement
implements ElementData {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final JsonObject jsonObject;
    private final String name;

    public JsonBackedConfigElement(String injectedName, JsonObject jsonObject) {
        this.name = injectedName;
        this.jsonObject = jsonObject;
    }

    @Override
    public Object get(String name) {
        return this.jsonObject.get(name);
    }

    @Override
    public Set<String> getKeys() {
        return this.jsonObject.keySet();
    }

    @Override
    public boolean containsKey(String name) {
        return this.jsonObject.keySet().contains(name);
    }

    @Override
    public String getGivenName() {
        return this.name;
    }

    @Override
    public <T> T convert(Object input, Class<T> type) {
        if (input instanceof JsonElement) {
            Object result = gson.fromJson((JsonElement)input, type);
            return (T)result;
        }
        throw new RuntimeException("Unable to convert json element from '" + input.getClass().getSimpleName() + "' to '" + type.getSimpleName() + "'");
    }

    @Override
    public Object getAsCommon(String key) {
        Object found = this.get(key);
        if (found == null) {
            return null;
        }
        Optional<Object> converted = ElementData.asCommonType(found);
        if (converted.isPresent()) {
            return converted.get();
        }
        if (found instanceof JsonObject) {
            JsonObject jo = (JsonObject)found;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            for (String s : jo.keySet()) {
                values.put(s, this.toCommon(jo.get(s)));
            }
            return values;
        }
        return this.toCommon(found);
    }

    public Object toCommon(Object srcValue) {
        Optional<Object> standards = ElementData.asCommonType(srcValue);
        if (standards.isPresent()) {
            return Optional.of(standards);
        }
        if (srcValue instanceof JsonElement) {
            JsonElement e = (JsonElement)srcValue;
            if (e.isJsonPrimitive()) {
                JsonPrimitive jp = e.getAsJsonPrimitive();
                if (jp.isBoolean()) {
                    return jp.getAsBoolean();
                }
                if (jp.isNumber()) {
                    Number number = jp.getAsNumber();
                    return number.doubleValue();
                }
                if (jp.isString()) {
                    return jp.getAsString();
                }
                if (jp.isJsonNull()) {
                    return null;
                }
                throw new RuntimeException("Unknown JSON primitive type for element: '" + e + "' type:'" + e.getClass().getCanonicalName() + "'");
            }
            if (e.isJsonObject()) {
                JsonObject jo = e.getAsJsonObject();
                LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
                for (String s : jo.keySet()) {
                    valueMap.put(s, this.toCommon(jo.get(s)));
                }
                return valueMap;
            }
            if (e.isJsonArray()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                JsonArray ja = e.getAsJsonArray();
                for (JsonElement jsonElement : ja) {
                    valueList.add(this.toCommon(jsonElement));
                }
                return valueList;
            }
        } else {
            throw new RuntimeException("Error traversing JSONElement structure. Unknown type: '" + srcValue.getClass().getCanonicalName() + "'");
        }
        throw new RuntimeException("Unable to convert value type from '" + srcValue.getClass().getCanonicalName() + "' to a common type.");
    }

    public String toString() {
        return this.getGivenName() + "(" + (this.extractElementName() != null ? this.extractElementName() : "null") + "):" + this.jsonObject.toString();
    }

    @Override
    public String extractElementName() {
        if (this.jsonObject.has("name")) {
            return this.jsonObject.get("name").getAsString();
        }
        return null;
    }
}

