/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.params;

import io.nosqlbench.api.config.params.DataSources;
import io.nosqlbench.api.config.params.Element;
import io.nosqlbench.api.config.params.ElementData;
import io.nosqlbench.api.config.params.ElementImpl;
import io.nosqlbench.api.config.params.MapBackedElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class NBParams {
    public static List<Element> some(Object source) {
        return DataSources.elements(source).stream().map(ElementImpl::new).collect(Collectors.toList());
    }

    public static Element one(Object source) {
        return NBParams.one(null, source);
    }

    public static Element one(String givenName, Object source) {
        List<ElementData> some = DataSources.elements(givenName, source);
        if (some.size() == 0) {
            throw new RuntimeException("One param object expected, but none found in '" + source + "'");
        }
        if (some.size() > 1) {
            LinkedHashMap<String, ElementData> data = new LinkedHashMap<String, ElementData>();
            for (ElementData elementData : some) {
                String name = elementData.getName();
                if (name == null || name.isBlank()) continue;
                data.put(name, elementData);
            }
            if (data.isEmpty()) {
                throw new RuntimeException("multiple elements found, but none contained a name for flattening to a map.");
            }
            return new ElementImpl(new MapBackedElement(givenName, data));
        }
        return new ElementImpl(some.get(0));
    }
}

