/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.standard;

import io.nosqlbench.api.config.standard.ConfigModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class ConfigSuggestions {
    public static Optional<String> getForParam(ConfigModel model, String param) {
        return ConfigSuggestions.suggestAlternateCase(model, param).or(() -> ConfigSuggestions.suggestAlternates(model, param, 4));
    }

    private static Optional<String> suggestAlternateCase(ConfigModel model, String param) {
        for (String cname : model.getNamedParams().keySet()) {
            if (!cname.equalsIgnoreCase(param)) continue;
            return Optional.of(" Did you mean '" + cname + "'?");
        }
        return Optional.empty();
    }

    public static Optional<String> suggestAlternates(Set<String> candidates, String provided, int maxDistance) {
        Set[] sorted = new Set[maxDistance + 1];
        for (int i = 0; i < sorted.length; ++i) {
            sorted[i] = new HashSet();
        }
        for (String candidate : candidates) {
            int distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)provided, (CharSequence)candidate);
            if (distance > maxDistance) continue;
            sorted[distance].add(candidate);
        }
        for (Set set : sorted) {
            if (set.size() > 1) {
                return Optional.of(" Did you mean one of '" + String.join((CharSequence)"','", set) + "' ?");
            }
            if (set.size() != 1) continue;
            return Optional.of(" Did you mean '" + (String)set.stream().findFirst().get() + "' ?");
        }
        return Optional.empty();
    }

    private static Optional<String> suggestAlternates(ConfigModel model, String param, int maxDistance) {
        HashMap<Integer, Set> suggestions = new HashMap<Integer, Set>();
        for (String candidate : model.getNamedParams().keySet()) {
            try {
                Integer distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)param, (CharSequence)candidate);
                if (distance > maxDistance) continue;
                Set strings = suggestions.computeIfAbsent(distance, d -> new HashSet());
                strings.add(candidate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList params = new ArrayList(suggestions.keySet());
        Collections.sort(params);
        List orderedSets = params.stream().map(suggestions::get).collect(Collectors.toList());
        if (orderedSets.size() == 0) {
            return Optional.empty();
        }
        if (((Set)orderedSets.get(0)).size() == 1) {
            return Optional.of(" Did you mean '" + (String)((Set)orderedSets.get(0)).stream().findFirst().get() + "'?");
        }
        return Optional.of(" Did you mean one of " + ((Set)orderedSets.get(0)).toString() + "?\n");
    }
}

