/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.standard;

import io.nosqlbench.api.config.standard.ConfigModel;
import io.nosqlbench.api.config.standard.NBCanConfigure;
import io.nosqlbench.api.config.standard.NBConfigModel;
import io.nosqlbench.api.config.standard.NBConfigModelProvider;
import io.nosqlbench.api.config.standard.NBConfiguration;
import java.util.Arrays;
import java.util.Collection;

public interface NBConfigurable
extends NBCanConfigure,
NBConfigModelProvider {
    @Override
    public void applyConfig(NBConfiguration var1);

    @Override
    public NBConfigModel getConfigModel();

    public static void applyMatching(NBConfiguration cfg, Object ... configurables) {
        for (Object configurable : configurables) {
            if (!(configurable instanceof NBConfigurable)) continue;
            NBConfigurable c = (NBConfigurable)configurable;
            NBConfiguration partial = c.getConfigModel().matchConfig(cfg);
            c.applyConfig(partial);
        }
    }

    public static NBConfigModel collectModels(Class<?> of, Collection<?> configurables) {
        ConfigModel model = ConfigModel.of(of);
        for (Object configurable : configurables) {
            if (!(configurable instanceof NBConfigurable)) continue;
            NBConfigurable c = (NBConfigurable)configurable;
            model = model.add(c.getConfigModel());
        }
        return model.asReadOnly();
    }

    public static NBConfigModel collectModels(Class<?> of, Object ... configurables) {
        return NBConfigurable.collectModels(of, Arrays.asList(configurables));
    }
}

