/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.standard;

import io.nosqlbench.api.config.standard.ConfigModel;
import io.nosqlbench.api.config.standard.NBConfigError;
import io.nosqlbench.api.config.standard.NBConfigModel;
import io.nosqlbench.api.config.standard.NBTypeConverter;
import io.nosqlbench.api.config.standard.Param;
import io.nosqlbench.api.system.NBEnvironment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;

public class NBConfiguration {
    private final LinkedHashMap<String, Object> data;
    private final NBConfigModel model;

    protected NBConfiguration(NBConfigModel model, LinkedHashMap<String, Object> validConfig) {
        this.data = validConfig;
        this.model = model;
    }

    public static NBConfiguration empty() {
        return new NBConfiguration(ConfigModel.of(Object.class).asReadOnly(), new LinkedHashMap<String, Object>());
    }

    public Optional<String> getEnvOptional(String name) {
        Optional<String> optionalValue = this.getOptional(name);
        if (optionalValue.isEmpty()) {
            return Optional.empty();
        }
        String span = optionalValue.get();
        Optional<String> maybeInterpolated = NBEnvironment.INSTANCE.interpolate(span);
        if (maybeInterpolated.isEmpty()) {
            throw new NBConfigError("Unable to interpolate '" + span + "' with env vars.");
        }
        return maybeInterpolated;
    }

    public String getWithEnv(String name) {
        return this.getWithEnv(name, String.class);
    }

    public <T> T getWithEnv(String name, Class<? extends T> vclass) {
        T value = this.get(name, vclass);
        if (value == null) {
            // empty if block
        }
        if (value instanceof String) {
            Optional<String> interpolated = NBEnvironment.INSTANCE.interpolate(value.toString());
            if (interpolated.isEmpty()) {
                throw new NBConfigError("Unable to interpolate env and sys props in '" + value + "'");
            }
            String result = interpolated.get();
            return ConfigModel.convertValueTo(this.getClass().getSimpleName(), name, result, vclass);
        }
        return value;
    }

    public <T> T get(String name) {
        Param<?> param = this.model.getNamedParams().get(name);
        Object object = this.data.get(name);
        Object object2 = object = object != null ? object : param.getDefaultValue();
        if (param.type.isInstance(object)) {
            return (T)object;
        }
        if (param.type.isAssignableFrom(object.getClass())) {
            return param.type.cast(object);
        }
        if (NBTypeConverter.canConvert(object, param.type)) {
            return NBTypeConverter.convert(object, param.type);
        }
        throw new NBConfigError("Unable to assign config value for field '" + name + "' of type '" + object.getClass().getCanonicalName() + "' to the required return type '" + param.type.getCanonicalName() + "' as specified in the config model for '" + this.model.getOf().getCanonicalName());
    }

    public <T> T get(String name, Class<? extends T> type) {
        Param param = this.model.getParam(name);
        if (param == null) {
            throw new NBConfigError("Parameter named '" + name + "' is not valid for " + this.model.getOf().getSimpleName() + ".");
        }
        if (!param.isRequired() && param.getDefaultValue() == null) {
            throw new RuntimeException("Non-optional get on optional parameter " + name + "' which has no default value while configuring " + this.model.getOf() + ".\nTo avoid user impact, ensure that ConfigModel and NBConfigurable usage are aligned.");
        }
        Object o = this.data.get(name);
        if (o == null) {
            if (param.getDefaultValue() == null) {
                throw new NBConfigError("config param '" + name + "' was not defined.");
            }
            o = param.getDefaultValue();
        }
        return ConfigModel.convertValueTo(this.getClass().getSimpleName(), name, o, type);
    }

    public Optional<String> getOptional(String name) {
        return this.getOptional(new String[]{name});
    }

    public Optional<String> getOptional(String ... names) {
        return this.getOptional(String.class, names);
    }

    public <T> Optional<T> getOptional(Class<T> type, String ... names) {
        Object o = null;
        for (String name : names) {
            Param param = this.model.getParam(names);
            if (param != null) {
                String pname;
                Iterator<String> iterator = param.getNames().iterator();
                while (iterator.hasNext() && (o = this.data.get(pname = iterator.next())) == null) {
                }
                continue;
            }
            throw new NBConfigError("Parameter was not found for " + Arrays.toString(names) + ".");
        }
        if (o == null) {
            return Optional.empty();
        }
        if (type.isInstance(o)) {
            return Optional.of(o);
        }
        if (type.isAssignableFrom(o.getClass())) {
            return Optional.of(type.cast(o));
        }
        if (NBTypeConverter.canConvert(o, type)) {
            return Optional.of(NBTypeConverter.convert(o, type));
        }
        throw new NBConfigError("config param " + Arrays.toString(names) + " was not assignable to class '" + type.getCanonicalName() + "'");
    }

    public <T> T getOrDefault(String name, T defaultValue) {
        Object o = this.data.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (defaultValue.getClass().isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new NBConfigError("config parameter '" + name + "' is not assignable to required type '" + defaultValue.getClass() + "'");
    }

    public <T> T param(String name, Class<? extends T> vclass) {
        Object o = this.data.get(name);
        Param<?> elem = this.model.getNamedParams().get(name);
        if (elem == null) {
            throw new NBConfigError("Invalid config element named '" + name + "'");
        }
        Class<?> type = elem.getType();
        Object typeCastedValue = type.cast(o);
        return (T)typeCastedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.model.getOf().getSimpleName()).append(":");
        sb.append(this.model);
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }

    public LinkedHashMap<String, Object> getMap() {
        return this.data;
    }
}

