/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.standard;

import io.nosqlbench.api.config.standard.NBTypeConverters;
import io.nosqlbench.api.config.standard.NBTypeSafeConversions;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public class NBTypeConverter {
    private static final List<Class<? extends NBTypeConverters>> CONVERTERS = List.of(NBTypeSafeConversions.class);
    public static Set<Class<?>> CORE_TYPES = new HashSet<Class<?>>(){
        {
            this.add(String.class);
            this.addAll(List.of(Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class));
            this.addAll(List.of(Integer.TYPE, Integer.class, Long.TYPE, Long.class));
            this.addAll(List.of(Float.TYPE, Float.class, Double.TYPE, Double.class));
        }
    };
    private static final Map<Class<?>, Class<?>> REMAP_to_primitive = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Byte.class, Byte.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Character.class, Character.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
        }
    };

    public static <I, O> boolean canConvert(I input, Class<O> outc) {
        if (outc.equals(input.getClass())) {
            return true;
        }
        if (outc.isAssignableFrom(input.getClass())) {
            return true;
        }
        if (ClassUtils.isAssignable(input.getClass(), outc, (boolean)true)) {
            return true;
        }
        if (String.class.isAssignableFrom(outc)) {
            return true;
        }
        if (outc.isPrimitive() && outc != Boolean.TYPE && outc != Void.TYPE && input instanceof Number) {
            return true;
        }
        return NBTypeConverter.lookup(input.getClass(), outc) != null;
    }

    private static <I, O> Method lookup(Class<I> input, Class<O> output) {
        Method candidate = null;
        for (Class<? extends NBTypeConverters> converters : CONVERTERS) {
            try {
                candidate = converters.getMethod("to_" + output.getSimpleName(), input);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (candidate == null) {
            return null;
        }
        if (!candidate.getReturnType().equals(output)) {
            return null;
        }
        if ((candidate.getModifiers() & 8) <= 0) {
            return null;
        }
        return candidate;
    }

    public static <T> Optional<T> tryConvert(Object input, Class<T> outType) {
        T converted = NBTypeConverter.do_convert(input, outType);
        return Optional.ofNullable(converted);
    }

    public static <T> T convertOr(Object input, T defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        return (T)NBTypeConverter.convert(input, defaultValue.getClass());
    }

    public static <T> T convert(Object input, Class<T> outType) {
        T converted = NBTypeConverter.do_convert(input, outType);
        if (converted == null) {
            throw new RuntimeException("Could not find conversion method\n" + NBTypeConverter.methodName(input.getClass(), outType) + "\nYou could implement it, or perhaps this is a type of conversion that should not be supported,\nfor example, if it might lose data as a narrowing conversion.");
        }
        return converted;
    }

    private static String methodName(Class<?> inType, Class<?> outType) {
        return "    public static " + REMAP_to_primitive.getOrDefault(outType, outType).getSimpleName() + " to_" + REMAP_to_primitive.getOrDefault(outType, outType).getSimpleName() + "(" + REMAP_to_primitive.getOrDefault(inType, inType).getSimpleName() + " in) {\n    ...\n    }";
    }

    private static <T> T do_convert(Object input, Class<T> outType) {
        if (outType.equals(input.getClass())) {
            return (T)input;
        }
        if (String.class.isAssignableFrom(outType)) {
            return (T)input.toString();
        }
        if (outType.isAssignableFrom(input.getClass())) {
            return outType.cast(input);
        }
        Class<T> loutc = REMAP_to_primitive.getOrDefault(outType, outType);
        Class<?> inType = input.getClass();
        Class<?> linc = REMAP_to_primitive.getOrDefault(inType, inType);
        if (loutc.isPrimitive() && loutc != Boolean.TYPE && loutc != Character.TYPE && input instanceof Number) {
            if (loutc == Long.TYPE) {
                return (T)Long.valueOf(((Number)input).longValue());
            }
            if (loutc == Integer.TYPE) {
                return (T)Integer.valueOf(((Number)input).intValue());
            }
            if (loutc == Float.TYPE) {
                return (T)Float.valueOf(((Number)input).floatValue());
            }
            if (loutc == Double.TYPE) {
                return (T)Double.valueOf(((Number)input).doubleValue());
            }
            if (loutc == Byte.TYPE) {
                return (T)Byte.valueOf(((Number)input).byteValue());
            }
            if (loutc == Short.TYPE) {
                return (T)Short.valueOf(((Number)input).shortValue());
            }
        }
        if (ClassUtils.isAssignable(input.getClass(), outType, (boolean)true)) {
            return (T)input;
        }
        Method converter = NBTypeConverter.lookup(linc, loutc);
        if (converter == null) {
            return null;
        }
        try {
            Object result = converter.invoke(null, input);
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to convert (" + input + ") to " + outType.getSimpleName() + ": " + e, e);
        }
    }
}

