/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.config.standard;

import io.nosqlbench.api.config.standard.NBConfigModelExpander;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Param<T> {
    private final List<String> names;
    public final Class<? extends T> type;
    private String description;
    private final T defaultValue;
    public boolean required;
    private Pattern regex;
    private final NBConfigModelExpander expander;

    public Param(List<String> names, Class<? extends T> type, String description, boolean required, T defaultValue, NBConfigModelExpander expander) {
        this.names = names;
        this.type = type;
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
        this.expander = expander;
    }

    public static Param<String> optional(String name) {
        return Param.optional(List.of(name), String.class);
    }

    public static Param<String> optional(List<String> names) {
        return Param.optional(names, String.class);
    }

    public static <V> Param<V> optional(List<String> names, Class<V> type) {
        return new Param<Object>(names, type, null, false, null, null);
    }

    public static <V> Param<V> optional(List<String> names, Class<V> type, String description) {
        return new Param<Object>(names, type, description, false, null, null);
    }

    public static <V> Param<V> optional(String name, Class<V> type) {
        return new Param<Object>(List.of(name), type, null, false, null, null);
    }

    public static <V> Param<V> optional(String name, Class<V> type, String description) {
        return new Param<Object>(List.of(name), type, description, false, null, null);
    }

    public static <V> Param<V> defaultTo(String name, V defaultValue) {
        return new Param(List.of(name), defaultValue.getClass(), null, true, defaultValue, null);
    }

    public static <V> Param<V> defaultTo(String name, V defaultValue, String description) {
        return new Param(List.of(name), defaultValue.getClass(), description, true, defaultValue, null);
    }

    public static <V> Param<V> defaultTo(List<String> names, V defaultValue) {
        return new Param(names, defaultValue.getClass(), null, true, defaultValue, null);
    }

    public static <V> Param<V> required(String name, Class<V> type) {
        return new Param<Object>(List.of(name), type, null, true, null, null);
    }

    public static <V> Param<V> required(List<String> names, Class<V> type) {
        return new Param<Object>(names, type, null, true, null, null);
    }

    public String toString() {
        return "Element{names='" + this.names.toString() + "', type=" + this.type + ", description='" + this.description + "', required=" + this.required + ", defaultValue = " + this.defaultValue + "}";
    }

    public List<String> getNames() {
        return this.names;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Param<?> setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Param<T> setDescription(String description) {
        this.description = description;
        return this;
    }

    public Param<T> setRegex(Pattern regex) {
        this.regex = regex;
        return this;
    }

    public Param<T> setRegex(String pattern) {
        this.regex = Pattern.compile(pattern);
        return this;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public CheckResult<T> validate(Object value) {
        Matcher matcher;
        if (value == null) {
            if (this.isRequired()) {
                return CheckResult.INVALID(this, null, "Value is null but " + this.getNames() + " is required");
            }
            return CheckResult.VALID(this, null, "Value is null, but " + this.getNames() + " is not required");
        }
        if (!this.getType().isAssignableFrom(value.getClass())) {
            return CheckResult.INVALID(this, value, "Can't assign " + value.getClass().getSimpleName() + " to " + this.getType().getSimpleName());
        }
        if (this.getRegex() != null && value instanceof CharSequence && !(matcher = this.getRegex().matcher(value.toString())).matches()) {
            return CheckResult.INVALID(this, value, "Could not match required pattern (" + this.getRegex().toString() + ") with value '" + value + "' for field '" + this.getNames() + "'");
        }
        return CheckResult.VALID(this, value, "All validators passed for field '" + this.getNames() + "'");
    }

    public NBConfigModelExpander getExpander() {
        return this.expander;
    }

    public Param<T> expand(NBConfigModelExpander expander) {
        return new Param<T>(this.names, this.type, this.description, this.required, this.defaultValue, expander);
    }

    public static final class CheckResult<T> {
        public final Param<T> element;
        public final Object value;
        public final String message;
        private final boolean isValid;

        private CheckResult(Param<T> e, Object value, String message, boolean isValid) {
            this.element = e;
            this.value = value;
            this.message = message;
            this.isValid = isValid;
        }

        public static <T> CheckResult<T> VALID(Param<T> element, Object value, String message) {
            return new CheckResult<T>(element, value, message, true);
        }

        public static <T> CheckResult<T> VALID(Param<T> element, Object value) {
            return new CheckResult<T>(element, value, "", true);
        }

        public static <T> CheckResult<T> INVALID(Param<T> element, Object value, String message) {
            return new CheckResult<T>(element, value, message, false);
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

