/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.spi.FileSystemProvider;
import java.util.function.Supplier;

public interface Content<T>
extends Supplier<CharSequence>,
Comparable<Content<?>> {
    public T getLocation();

    public URI getURI();

    default public URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Path asPath();

    default public String asString() {
        return this.getCharBuffer().toString();
    }

    public CharBuffer getCharBuffer();

    @Override
    default public CharSequence get() {
        return this.getCharBuffer();
    }

    @Override
    default public int compareTo(Content<?> other) {
        return this.getURI().compareTo(other.getURI());
    }

    default public Reader getReader() {
        InputStream inputStream = this.getInputStream();
        return new InputStreamReader(inputStream);
    }

    default public InputStream getInputStream() {
        try {
            Path path = this.asPath();
            FileSystem fileSystem = path.getFileSystem();
            FileSystemProvider provider = fileSystem.provider();
            InputStream stream = provider.newInputStream(path, StandardOpenOption.READ);
            return stream;
        }
        catch (IOException path) {
            String stringdata = this.getCharBuffer().toString();
            return new ByteArrayInputStream(stringdata.getBytes());
        }
    }
}

