/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.content;

import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.content.NBIOWalker;
import io.nosqlbench.api.content.NBPathsAPI;
import io.nosqlbench.api.content.PathContent;
import io.nosqlbench.api.content.URIResolver;
import io.nosqlbench.api.content.URIResolvers;
import io.nosqlbench.api.errors.BasicError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;

public class NBIO
implements NBPathsAPI.Facets {
    private static String[] globalIncludes = new String[0];
    private URIResolver resolver;
    private List<String> names = new ArrayList<String>();
    private List<String> extensions = new ArrayList<String>();
    private Set<String> prefixes = new HashSet<String>(Arrays.asList(globalIncludes));
    private static final Pattern extensionPattern = Pattern.compile("\\.[a-zA-Z]+");
    private static final Pattern wildcardsPattern = Pattern.compile(".*?[^?+*][\\?\\+\\*].*");

    public static synchronized void addGlobalIncludes(String[] globalIncludes) {
        NBIO.globalIncludes = globalIncludes;
    }

    private NBIO() {
    }

    private NBIO(URIResolver resolver, Set<String> prefixes, List<String> names, List<String> extensions) {
        this.resolver = resolver;
        this.prefixes = prefixes;
        this.names = names;
        this.extensions = extensions;
    }

    public static List<String> readLines(String filename) {
        Content<?> data = NBIO.all().prefix("data").name(filename).first().orElseThrow(() -> new BasicError("Unable to read lines from " + filename));
        String[] split = data.getCharBuffer().toString().split("\n");
        return Arrays.asList(split);
    }

    public static CSVParser readFileCSV(String filename, String ... searchPaths) {
        return NBIO.readFileDelimCSV(filename, ',', searchPaths);
    }

    public static CSVParser readFileDelimCSV(String filename, char delim, String ... searchPaths) {
        Reader reader = NBIO.readReader(filename, searchPaths);
        CSVFormat format = CSVFormat.DEFAULT.withDelimiter(delim).withFirstRecordAsHeader();
        try {
            CSVParser parser = new CSVParser(reader, format);
            return parser;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream readInputStream(String filename, String ... searchPaths) {
        return NBIO.all().prefix(searchPaths).name(filename).one().getInputStream();
    }

    private static Reader readReader(String filename, String ... searchPaths) {
        return NBIO.all().prefix(searchPaths).name(filename).one().getReader();
    }

    public static CharBuffer readCharBuffer(String fileName, String ... searchPaths) {
        return NBIO.all().prefix(searchPaths).name(fileName).one().getCharBuffer();
    }

    public static Path getFirstLocalPath(String ... potentials) {
        Optional<Content<?>> first = NBIO.local().name(potentials).first();
        return first.orElseThrow(() -> new BasicError("Unable to find loadable content at " + String.join((CharSequence)",", potentials))).asPath();
    }

    public static Optional<Path> findFirstLocalPath(String ... potentials) {
        Optional<Content<?>> first = NBIO.local().name(potentials).first();
        Optional<Path> path = first.map(Content::asPath);
        return path;
    }

    public static InputStream readInputStream(String fromPath, String yaml, String[] searchPaths) {
        return null;
    }

    @Override
    public NBPathsAPI.GetPrefix localContent() {
        this.resolver = URIResolvers.inFS().inCP();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix remoteContent() {
        this.resolver = URIResolvers.inURLs();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix internalContent() {
        this.resolver = URIResolvers.inClasspath();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix fileContent() {
        this.resolver = URIResolvers.inFS();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix allContent() {
        this.resolver = URIResolvers.inFS().inCP().inURLs();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix prefix(String ... searchPaths) {
        HashSet<String> addingPaths = new HashSet<String>(this.prefixes);
        addingPaths.addAll(Arrays.asList(searchPaths));
        return new NBIO(this.resolver, addingPaths, this.names, this.extensions);
    }

    @Override
    public NBPathsAPI.DoSearch search(String ... searches) {
        ArrayList<String> prefixesToAdd = new ArrayList<String>();
        ArrayList<String> namesToAdd = new ArrayList<String>();
        ArrayList<String> extensionsToAdd = new ArrayList<String>();
        for (String search : searches) {
            int literalsTill;
            String[] parts;
            int dotAt = search.lastIndexOf(46);
            String candidateExtension = search.substring(dotAt);
            if (extensionPattern.matcher(candidateExtension).matches()) {
                extensionsToAdd.add(candidateExtension);
                search = search.substring(0, dotAt);
            }
            if ((parts = search.split(File.separator)).length > 0 && search.startsWith(File.separator) && !parts[0].startsWith(File.separator)) {
                parts[0] = File.separator + parts[0];
            }
            for (literalsTill = 0; literalsTill < parts.length - 1 && !wildcardsPattern.matcher(parts[literalsTill]).matches(); ++literalsTill) {
            }
            CharSequence[] prefixary = new String[literalsTill];
            System.arraycopy(parts, 0, prefixary, 0, prefixary.length);
            String prefix = String.join((CharSequence)File.separator, prefixary);
            prefix = prefix.isEmpty() ? "./" : prefix;
            prefixesToAdd.add(prefix);
            CharSequence[] nameary = new String[parts.length - literalsTill];
            System.arraycopy(parts, literalsTill, nameary, 0, nameary.length);
            String name = String.join((CharSequence)File.separator, nameary);
            namesToAdd.add(name);
        }
        return this.prefix(prefixesToAdd.toArray(new String[0])).name(namesToAdd.toArray(new String[0])).extension(extensionsToAdd.toArray(new String[0]));
    }

    @Override
    public NBPathsAPI.GetExtension name(String ... searchNames) {
        ArrayList<String> addingNames = new ArrayList<String>(this.names);
        addingNames.addAll(Arrays.asList(searchNames));
        return new NBIO(this.resolver, this.prefixes, addingNames, this.extensions);
    }

    @Override
    public NBPathsAPI.DoSearch extension(String ... extensions) {
        ArrayList<String> addingExtensions = new ArrayList<String>(this.extensions);
        for (String addingExtension : extensions) {
            addingExtensions.add(NBIO.dotExtension(addingExtension));
        }
        return new NBIO(this.resolver, this.prefixes, this.names, addingExtensions);
    }

    public static NBPathsAPI.GetPrefix all() {
        return new NBIO().allContent();
    }

    public static NBPathsAPI.GetPrefix classpath() {
        return new NBIO().internalContent();
    }

    public static NBPathsAPI.GetPrefix fs() {
        return new NBIO().fileContent();
    }

    public static NBPathsAPI.GetPrefix local() {
        return new NBIO().localContent();
    }

    public static NBPathsAPI.GetPrefix remote() {
        return new NBIO().remoteContent();
    }

    @Override
    public Optional<Content<?>> first() {
        List<Content<?>> list = this.list();
        if (list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Optional<Content<?>> maybeOne() {
        List<Content<?>> list = this.list();
        if (list.size() > 1) {
            throw new BasicError("Found more than one source for " + this + ", but expected to find one at most.");
        }
        throw new RuntimeException("Invalid code, go fix it, this should never happen.");
    }

    @Override
    public Content<?> one() {
        List<Content<?>> list = this.list();
        if (list.size() == 0) {
            throw new BasicError("Unable to find even a single source for '" + this + "'");
        }
        if (list.size() > 1) {
            String found = list.stream().map(c -> c.getURI().toString()).collect(Collectors.joining("\n", "\n", "\n"));
            throw new BasicError("Found too many sources for '" + this + "', ambiguous name. Pick from " + found);
        }
        return list.get(0);
    }

    @Override
    public List<List<Content<?>>> resolveEach() {
        ArrayList resolved = new ArrayList();
        for (String name : this.names) {
            LinkedHashSet<String> slotSearchPaths = this.expandNamesAndSuffixes(List.of(name), new HashSet<String>(this.extensions));
            Object content = null;
            for (String slotSearchPath : slotSearchPaths) {
                List<Content<?>> contents = this.resolver.resolve(slotSearchPath);
                resolved.add(contents);
            }
        }
        return resolved;
    }

    public LinkedHashSet<String> expandNamesAndSuffixes() {
        return this.expandNamesAndSuffixes(this.names, new HashSet<String>(this.extensions));
    }

    public LinkedHashSet<String> expandNamesAndSuffixes(List<String> _names, Set<String> _suffixes) {
        LinkedHashSet<String> searches = new LinkedHashSet<String>();
        if (_names.size() == 0 && this.prefixes.size() == 0) {
            searches.add(".*");
        } else if (_names.size() > 0 && _suffixes.size() == 0) {
            searches.addAll(_names);
        } else if (_names.size() == 0 && _suffixes.size() > 0) {
            _suffixes.stream().map(s -> ".*" + s).forEach(searches::add);
        } else {
            Iterator<String> iterator = _names.iterator();
            while (iterator.hasNext()) {
                String name;
                String basename = name = iterator.next();
                boolean suffixed = false;
                for (String suffix : _suffixes) {
                    if (!name.endsWith(suffix)) continue;
                    suffixed = true;
                    basename = name.substring(0, name.length() - suffix.length());
                    break;
                }
                for (String suffix : _suffixes) {
                    searches.add(basename + suffix);
                }
            }
        }
        return searches;
    }

    @Override
    public List<Content<?>> list() {
        LinkedHashSet<String> searches = this.expandNamesAndSuffixes();
        LinkedHashSet foundFiles = new LinkedHashSet();
        for (String search : searches) {
            List<Content<?>> founds = this.resolver.resolve(search);
            foundFiles.addAll(founds);
        }
        if (searches.size() == 0) {
            searches.add(".*");
        }
        for (String prefix : this.prefixes) {
            List<Path> directories = this.resolver.resolveDirectory(prefix);
            NBIOWalker.CollectVisitor capture = new NBIOWalker.CollectVisitor(true, false);
            for (Path dirPath : directories) {
                for (String searchPattern : searches) {
                    NBIOWalker.PathSuffixFilter filter = new NBIOWalker.PathSuffixFilter(searchPattern);
                    NBIOWalker.walkFullPath(dirPath, capture, filter);
                }
            }
            capture.get().stream().map(PathContent::new).forEach(foundFiles::add);
        }
        return new ArrayList(foundFiles);
    }

    @Override
    public List<Path> relativeTo(String ... base) {
        String base1 = base[0];
        String[] rest = new String[base.length - 1];
        System.arraycopy(base, 1, rest, 0, rest.length);
        ArrayList<Path> paths = new ArrayList<Path>();
        List<Content<?>> list = this.list();
        for (Content<?> c : list) {
            Path path = c.asPath();
            Path fsBase = path.getFileSystem().getPath(base1, rest);
            Path relative = fsBase.relativize(path);
            paths.add(relative);
        }
        return paths;
    }

    private static String tailmatch(String name) {
        if (!((String)name).startsWith("^") && !((String)name).startsWith(".")) {
            name = ".*" + (String)name;
        }
        return name;
    }

    private static String dotExtension(String extension) {
        return extension.startsWith(".") ? extension : "." + extension;
    }

    public String toString() {
        return "NBIO{resolver=" + this.resolver + ", prefixes=" + this.prefixes + ", names=" + this.names + ", extensions=" + this.extensions + "}";
    }
}

