/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.content;

import io.nosqlbench.api.content.Content;
import java.io.IOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

public class PathContent
implements Content<Path> {
    private final Path path;

    public PathContent(Path path) {
        this.path = path;
    }

    @Override
    public Path getLocation() {
        return this.path;
    }

    @Override
    public URI getURI() {
        return this.path.toUri();
    }

    @Override
    public CharBuffer getCharBuffer() {
        try {
            String content = Files.readString(this.path, StandardCharsets.UTF_8);
            return CharBuffer.wrap(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path asPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathContent that = (PathContent)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return "PathContent{" + this.getURI().toString() + "}";
    }
}

