/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.content;

import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.content.ContentResolver;
import io.nosqlbench.api.content.PathContent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResolverForClasspath
implements ContentResolver {
    public static final ContentResolver INSTANCE = new ResolverForClasspath();

    private List<Path> resolvePaths(URI uri) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (uri.getScheme() != null && !uri.getScheme().isEmpty()) {
            return null;
        }
        try {
            Enumeration<URL> systemResources = ClassLoader.getSystemResources(uri.getPath());
            while (systemResources.hasMoreElements()) {
                URL url = systemResources.nextElement();
                Path p = this.normalize(url);
                paths.add(p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return paths;
    }

    private Path normalize(URL url) {
        if (url == null) {
            return null;
        }
        URI resolved = URI.create(url.toExternalForm());
        if (resolved.getScheme().equals("file")) {
            Path current = Paths.get("", new String[0]).toAbsolutePath();
            Path logical = Path.of(resolved.getPath(), new String[0]);
            Path relativePath = current.relativize(logical);
            return relativePath;
        }
        try {
            FileSystem fs = FileSystems.getFileSystem(resolved);
        }
        catch (FileSystemNotFoundException notfound) {
            try {
                FileSystem fs = FileSystems.newFileSystem(resolved, Map.of());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path fspath = Path.of(resolved);
        return fspath;
    }

    @Override
    public List<Content<?>> resolve(URI uri) {
        List<Path> paths = this.resolvePaths(uri);
        if (paths == null) {
            return List.of();
        }
        List<Content<?>> contents = paths.stream().map(PathContent::new).collect(Collectors.toList());
        return contents;
    }

    @Override
    public List<Path> resolveDirectory(URI uri) {
        List<Path> path = this.resolvePaths(uri);
        ArrayList<Path> dirs = new ArrayList<Path>();
        for (Path dirpath : path) {
            if (!Files.isDirectory(dirpath, new LinkOption[0])) continue;
            dirs.add(dirpath);
        }
        return dirs;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

