/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.content;

import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.content.ContentResolver;
import io.nosqlbench.api.content.PathContent;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResolverForFilesystem
implements ContentResolver {
    public static ResolverForFilesystem INSTANCE = new ResolverForFilesystem();
    private static final Logger logger = LogManager.getLogger(ResolverForFilesystem.class);

    @Override
    public List<Content<?>> resolve(URI uri) {
        ArrayList contents = new ArrayList();
        Path path = this.resolvePath(uri);
        if (path != null) {
            contents.add(new PathContent(path));
        }
        return contents;
    }

    @Override
    public List<Path> resolveDirectory(URI uri) {
        ArrayList<Path> dirs = new ArrayList<Path>();
        Path path = this.resolvePath(uri);
        if (path != null && Files.isDirectory(path, new LinkOption[0])) {
            dirs.add(path);
        }
        return dirs;
    }

    private Path resolvePath(URI uri) {
        if (uri.getScheme() != null && !uri.getScheme().isEmpty() && !uri.getScheme().equals("file")) {
            return null;
        }
        Path pathFromUri = Path.of(uri.getPath(), new String[0]);
        if (Files.isReadable(pathFromUri)) {
            return pathFromUri;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

