/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.content;

import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.content.ContentResolver;
import io.nosqlbench.api.content.ResolverForClasspath;
import io.nosqlbench.api.content.ResolverForFilesystem;
import io.nosqlbench.api.content.ResolverForURL;
import io.nosqlbench.api.errors.BasicError;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class URIResolver
implements ContentResolver {
    private List<ContentResolver> loaders = new ArrayList<ContentResolver>();
    private static final List<ContentResolver> EVERYWHERE = List.of(ResolverForURL.INSTANCE, ResolverForFilesystem.INSTANCE, ResolverForClasspath.INSTANCE);
    private List<String> extensions;
    private List<Path> extraPaths;

    public URIResolver all() {
        this.loaders = EVERYWHERE;
        return this;
    }

    public URIResolver inFS() {
        this.loaders.add(ResolverForFilesystem.INSTANCE);
        return this;
    }

    public URIResolver inURLs() {
        this.loaders.add(ResolverForURL.INSTANCE);
        return this;
    }

    public URIResolver inCP() {
        this.loaders.add(ResolverForClasspath.INSTANCE);
        return this;
    }

    @Override
    public List<Content<?>> resolve(String uri) {
        return this.resolve(URI.create(uri));
    }

    @Override
    public List<Path> resolveDirectory(URI uri) {
        ArrayList<Path> dirs = new ArrayList<Path>();
        for (ContentResolver loader : this.loaders) {
            dirs.addAll(loader.resolveDirectory(uri));
        }
        return dirs;
    }

    @Override
    public List<Content<?>> resolve(URI uri) {
        ArrayList resolved = new ArrayList();
        for (ContentResolver loader : this.loaders) {
            List<Content<?>> contents = loader.resolve(uri);
            resolved.addAll(contents);
        }
        return resolved;
    }

    public List<Content<?>> resolveAll(String uri) {
        return this.resolveAll(URI.create(uri));
    }

    public List<Content<?>> resolveAll(URI uri) {
        ArrayList allFound = new ArrayList();
        for (ContentResolver loader : this.loaders) {
            allFound.addAll(loader.resolve(uri));
        }
        return allFound;
    }

    public URIResolver extension(String extension) {
        this.extensions = this.extensions == null ? new ArrayList() : this.extensions;
        this.extensions.add(extension);
        return this;
    }

    public URIResolver extraPaths(String extraPath) {
        this.extraPaths = this.extraPaths == null ? new ArrayList() : this.extraPaths;
        this.extraPaths.add(Path.of(extraPath, new String[0]));
        return this;
    }

    public Content<?> resolveOne(String candidatePath) {
        List<Content<?>> contents = this.resolveAll(candidatePath);
        if (contents.size() == 1) {
            return contents.get(0);
        }
        if (contents.size() == 0) {
            return null;
        }
        throw new BasicError("Error while loading content '" + candidatePath + "', only one is allowed, but " + contents.size() + " were found");
    }

    public String toString() {
        return "[resolver]";
    }
}

