/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.docsapi;

import io.nosqlbench.api.content.NBIO;
import io.nosqlbench.api.docsapi.DocsBinder;
import io.nosqlbench.api.docsapi.DocsNameSpace;
import io.nosqlbench.api.docsapi.DocsNameSpaceImpl;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Docs
implements DocsBinder {
    private final LinkedList<DocsNameSpaceImpl> namespaces = new LinkedList();

    public static DocsBinder forRoot(String namespace, Path root) {
        return new Docs().namespace(namespace).addPath(root).asDocsBinder();
    }

    public static DocsBinder empty() {
        return new Docs();
    }

    public Docs namespace(String namespace) {
        return this.addNamespace(namespace);
    }

    public Docs addFirstFoundContentPath(String ... potentials) {
        Path pathIn = NBIO.getFirstLocalPath(potentials);
        if (pathIn == null || !Files.exists(pathIn, new LinkOption[0])) {
            throw new RuntimeException("Unable to find path in one of " + Arrays.stream(potentials).collect(Collectors.joining(",")));
        }
        return this.addContentsOf(pathIn);
    }

    public Docs addFirstFoundPath(String ... potentials) {
        Path pathIn = NBIO.getFirstLocalPath(potentials);
        if (pathIn == null || !Files.exists(pathIn, new LinkOption[0])) {
            throw new RuntimeException("Unable to find a path in one of " + Arrays.stream(potentials).collect(Collectors.joining(",")));
        }
        return this.addPath(pathIn);
    }

    public Docs addContentsOf(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new RuntimeException("path '" + root + "' must be a directory to use addContentsOf(...)");
        }
        if (this.namespaces.peekLast() == null) {
            throw new RuntimeException("You must add a namespace first.");
        }
        try {
            DirectoryStream<Path> paths = Files.newDirectoryStream(root);
            for (Path path : paths) {
                this.addPath(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Docs addPath(Path path) {
        if (this.namespaces.peekLast() == null) {
            throw new RuntimeException("You must add a namespace first.");
        }
        this.namespaces.peekLast().addPath(path);
        return this;
    }

    public Docs setEnabledByDefault(boolean enabledByDefault) {
        if (this.namespaces.peekLast() == null) {
            throw new RuntimeException("You must add a namespace first.");
        }
        this.namespaces.peekLast().setEnabledByDefault(enabledByDefault);
        return this;
    }

    private Docs addNamespace(String name) {
        this.namespaces.add(new DocsNameSpaceImpl(name));
        return this;
    }

    @Override
    public DocsBinder merge(DocsBinder other) {
        for (DocsNameSpace namespace : other.getNamespaces()) {
            this.namespace(namespace.getName());
            this.setEnabledByDefault(namespace.isEnabledByDefault());
            for (Path path : namespace.getPaths()) {
                this.addPath(path);
            }
        }
        return this.asDocsBinder();
    }

    @Override
    public DocsBinder merge(DocsNameSpace namespace) {
        this.namespace(namespace.getName());
        this.setEnabledByDefault(namespace.isEnabledByDefault());
        for (Path path : namespace) {
            this.addPath(path);
        }
        return this.asDocsBinder();
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (DocsNameSpaceImpl ns : this.namespaces) {
            paths.addAll(ns.getPaths());
        }
        return paths;
    }

    @Override
    public Map<String, Set<Path>> getPathMap() {
        HashMap<String, Set<Path>> pm = new HashMap<String, Set<Path>>();
        for (DocsNameSpaceImpl ns : this.namespaces) {
            pm.put(ns.getName(), new HashSet<Path>(ns.getPaths()));
        }
        return pm;
    }

    @Override
    public List<DocsNameSpace> getNamespaces() {
        return new LinkedList<DocsNameSpace>(this.namespaces);
    }

    @Override
    public Iterator<DocsNameSpace> iterator() {
        ArrayList<DocsNameSpaceImpl> pathinfos = new ArrayList<DocsNameSpaceImpl>(this.namespaces);
        return pathinfos.iterator();
    }

    public Map<String, Set<Path>> getPathMaps() {
        HashMap<String, Set<Path>> maps = new HashMap<String, Set<Path>>();
        for (DocsNameSpaceImpl namespace : this.namespaces) {
            HashSet paths = new HashSet();
            namespace.forEach(paths::add);
            maps.put(namespace.getName(), paths);
        }
        return maps;
    }

    public DocsBinder asDocsBinder() {
        return this;
    }

    @Override
    public DocsBinder remove(Set<String> namespaces) {
        Docs removed = new Docs();
        ListIterator iter = this.namespaces.listIterator();
        while (iter.hasNext()) {
            DocsNameSpaceImpl next = (DocsNameSpaceImpl)iter.next();
            if (!namespaces.contains(next.getName())) continue;
            iter.previous();
            iter.remove();
            removed.merge(next);
        }
        return removed;
    }
}

