/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.engine.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import io.nosqlbench.api.config.NBNamedElement;
import io.nosqlbench.api.engine.activityapi.core.MetricRegistryService;
import io.nosqlbench.api.engine.metrics.ClassicHistoListener;
import io.nosqlbench.api.engine.metrics.ClassicTimerListener;
import io.nosqlbench.api.engine.metrics.DeltaHdrHistogramReservoir;
import io.nosqlbench.api.engine.metrics.HistoIntervalLogger;
import io.nosqlbench.api.engine.metrics.HistoStatsLogger;
import io.nosqlbench.api.engine.metrics.MetricsCloseable;
import io.nosqlbench.api.engine.metrics.MetricsRegistryMount;
import io.nosqlbench.api.engine.metrics.NicerHistogram;
import io.nosqlbench.api.engine.metrics.NicerTimer;
import io.nosqlbench.api.engine.util.Unit;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActivityMetrics {
    private static final Logger logger = LogManager.getLogger(ActivityMetrics.class);
    public static final String HDRDIGITS_PARAM = "hdr_digits";
    public static final int DEFAULT_HDRDIGITS = 4;
    private static int _HDRDIGITS = 4;
    private static MetricRegistry registry;
    public static MetricFilter METRIC_FILTER;
    private static final List<MetricsCloseable> metricsCloseables;

    public static int getHdrDigits() {
        return _HDRDIGITS;
    }

    public static void setHdrDigits(int hdrDigits) {
        _HDRDIGITS = hdrDigits;
    }

    private ActivityMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Metric register(NBNamedElement named, String name, MetricProvider metricProvider) {
        String fullMetricName = named.getName() + "." + name;
        Metric metric = (Metric)ActivityMetrics.get().getMetrics().get(fullMetricName);
        if (metric == null) {
            NBNamedElement nBNamedElement = named;
            synchronized (nBNamedElement) {
                metric = (Metric)ActivityMetrics.get().getMetrics().get(fullMetricName);
                if (metric == null) {
                    metric = metricProvider.getMetric();
                    return ActivityMetrics.get().register(fullMetricName, metric);
                }
            }
        }
        return metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Metric register(ScriptContext context, String name, MetricProvider metricProvider) {
        Metric metric = (Metric)ActivityMetrics.get().getMetrics().get(name);
        if (metric == null) {
            ScriptContext scriptContext = context;
            synchronized (scriptContext) {
                metric = (Metric)ActivityMetrics.get().getMetrics().get(name);
                if (metric == null) {
                    metric = metricProvider.getMetric();
                    Metric registered = ActivityMetrics.get().register(name, metric);
                    logger.info(() -> "registered scripting metric: " + name);
                    return registered;
                }
            }
        }
        return metric;
    }

    public static Timer timer(NBNamedElement named, String name, int hdrdigits) {
        String fullMetricName = named.getName() + "." + name;
        Timer registeredTimer = (Timer)ActivityMetrics.register(named, name, () -> new NicerTimer(fullMetricName, new DeltaHdrHistogramReservoir(fullMetricName, hdrdigits)));
        return registeredTimer;
    }

    public static Timer timer(String fullMetricName) {
        NicerTimer timer = (NicerTimer)ActivityMetrics.get().register(fullMetricName, (Metric)new NicerTimer(fullMetricName, new DeltaHdrHistogramReservoir(fullMetricName, _HDRDIGITS)));
        return timer;
    }

    public static Histogram histogram(NBNamedElement named, String name, int hdrdigits) {
        String fullMetricName = named.getName() + "." + name;
        return (Histogram)ActivityMetrics.register(named, name, () -> new NicerHistogram(fullMetricName, new DeltaHdrHistogramReservoir(fullMetricName, hdrdigits)));
    }

    public static Histogram histogram(String fullname) {
        NicerHistogram histogram = (NicerHistogram)ActivityMetrics.get().register(fullname, (Metric)new NicerHistogram(fullname, new DeltaHdrHistogramReservoir(fullname, _HDRDIGITS)));
        return histogram;
    }

    public static Counter counter(NBNamedElement named, String name) {
        return (Counter)ActivityMetrics.register(named, name, Counter::new);
    }

    public static Meter meter(NBNamedElement named, String name) {
        return (Meter)ActivityMetrics.register(named, name, Meter::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricRegistry get() {
        if (registry != null) {
            return registry;
        }
        Class<ActivityMetrics> clazz = ActivityMetrics.class;
        synchronized (ActivityMetrics.class) {
            if (registry == null) {
                registry = ActivityMetrics.lookupRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static <T> Gauge<T> gauge(NBNamedElement named, String name, Gauge<T> gauge) {
        return (Gauge)ActivityMetrics.register(named, name, () -> gauge);
    }

    public static <T> Gauge<T> gauge(ScriptContext scriptContext, String name, Gauge<T> gauge) {
        return (Gauge)ActivityMetrics.register(scriptContext, name, () -> gauge);
    }

    private static MetricRegistry lookupRegistry() {
        ServiceLoader<MetricRegistryService> metricRegistryServices = ServiceLoader.load(MetricRegistryService.class);
        ArrayList mrss = new ArrayList();
        metricRegistryServices.iterator().forEachRemaining(mrss::add);
        if (mrss.size() == 1) {
            return ((MetricRegistryService)mrss.get(0)).getMetricRegistry();
        }
        String infoMsg = "Unable to load a dynamic MetricRegistry via ServiceLoader, using the default.";
        logger.info(infoMsg);
        return new MetricRegistry();
    }

    public static MetricRegistry getMetricRegistry() {
        return ActivityMetrics.get();
    }

    public static void addHistoLogger(String sessionName, String pattern, String filename, String interval) {
        if (filename.contains("_SESSION_")) {
            filename = filename.replace("_SESSION_", sessionName);
        }
        Pattern compiledPattern = Pattern.compile(pattern);
        File logfile = new File(filename);
        long intervalMillis = Unit.msFor(interval).orElseThrow(() -> new RuntimeException("Unable to parse interval spec:'" + interval + "'"));
        HistoIntervalLogger histoIntervalLogger = new HistoIntervalLogger(sessionName, logfile, compiledPattern, intervalMillis);
        logger.debug(() -> "attaching " + histoIntervalLogger + " to the metrics registry.");
        ActivityMetrics.get().addListener((MetricRegistryListener)histoIntervalLogger);
        metricsCloseables.add(histoIntervalLogger);
    }

    public static void addStatsLogger(String sessionName, String pattern, String filename, String interval) {
        if (filename.contains("_SESSION_")) {
            filename = filename.replace("_SESSION_", sessionName);
        }
        Pattern compiledPattern = Pattern.compile(pattern);
        File logfile = new File(filename);
        long intervalMillis = Unit.msFor(interval).orElseThrow(() -> new RuntimeException("Unable to parse interval spec:" + interval + "'"));
        HistoStatsLogger histoStatsLogger = new HistoStatsLogger(sessionName, logfile, compiledPattern, intervalMillis, TimeUnit.NANOSECONDS);
        logger.debug(() -> "attaching " + histoStatsLogger + " to the metrics registry.");
        ActivityMetrics.get().addListener((MetricRegistryListener)histoStatsLogger);
        metricsCloseables.add(histoStatsLogger);
    }

    public static void addClassicHistos(String sessionName, String pattern, String prefix, String interval) {
        Pattern compiledPattern = Pattern.compile(pattern);
        long intervalMillis = Unit.msFor(interval).orElseThrow(() -> new RuntimeException("Unable to parse interval spec:" + interval + "'"));
        ClassicHistoListener classicHistoListener = new ClassicHistoListener(ActivityMetrics.get(), sessionName, prefix, compiledPattern, interval, TimeUnit.NANOSECONDS);
        logger.debug(() -> "attaching histo listener " + classicHistoListener + " to the metrics registry.");
        ActivityMetrics.get().addListener((MetricRegistryListener)classicHistoListener);
        ClassicTimerListener classicTimerListener = new ClassicTimerListener(ActivityMetrics.get(), sessionName, prefix, compiledPattern, interval, TimeUnit.NANOSECONDS);
        logger.debug(() -> "attaching timer listener " + classicTimerListener + " to the metrics registry.");
        ActivityMetrics.get().addListener((MetricRegistryListener)classicTimerListener);
    }

    public static void closeMetrics(boolean showChart) {
        logger.trace("Closing all registered metrics closable objects.");
        for (MetricsCloseable metricsCloseable : metricsCloseables) {
            logger.trace(() -> "closing metrics closeable: " + metricsCloseable);
            metricsCloseable.closeMetrics();
            if (!showChart) continue;
            metricsCloseable.chart();
        }
    }

    public static void reportTo(PrintStream out) {
        out.println("====================  BEGIN-METRIC-LOG  ====================");
        ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)ActivityMetrics.getMetricRegistry()).convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).outputTo(out).build();
        consoleReporter.report();
        out.println("====================   END-METRIC-LOG   ====================");
    }

    public static void mountSubRegistry(String mountPrefix, MetricRegistry subRegistry) {
        new MetricsRegistryMount(ActivityMetrics.getMetricRegistry(), subRegistry, mountPrefix);
    }

    public static void removeActivityMetrics(NBNamedElement named) {
        ActivityMetrics.get().getMetrics().keySet().stream().filter(s -> s.startsWith(named.getName() + ".")).forEach(arg_0 -> ((MetricRegistry)ActivityMetrics.get()).remove(arg_0));
    }

    static {
        METRIC_FILTER = (name, metric) -> true;
        metricsCloseables = new ArrayList<MetricsCloseable>();
    }

    private static interface MetricProvider {
        public Metric getMetric();
    }
}

