/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.engine.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;

public abstract class CapabilityHook<T>
implements MetricRegistryListener {
    private final Map<String, T> capables = new HashMap<String, T>();

    public abstract void onCapableAdded(String var1, T var2);

    public abstract void onCapableRemoved(String var1, T var2);

    protected abstract Class<T> getCapabilityClass();

    public void onHistogramAdded(String name, Histogram metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    public void onHistogramRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    public void onTimerAdded(String name, Timer metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    public void onTimerRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    public void onGaugeAdded(String name, Gauge<?> metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    public void onGaugeRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    public void onCounterAdded(String name, Counter metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    public void onCounterRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    public void onMeterAdded(String name, Meter metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    public void onMeterRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }
}

