/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.engine.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import io.nosqlbench.api.engine.metrics.CapabilityHook;
import io.nosqlbench.api.engine.metrics.TimerAttachment;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassicTimerListener
extends CapabilityHook<TimerAttachment> {
    private static final Logger logger = LogManager.getLogger(ClassicTimerListener.class);
    private final MetricRegistry metricsRegistry;
    private final String sessionName;
    private final String prefix;
    private final Pattern pattern;
    private final String interval;
    private final TimeUnit nanoseconds;
    private final Map<String, Attachment> histos = new HashMap<String, Attachment>();

    public ClassicTimerListener(MetricRegistry metricRegistry, String sessionName, String prefix, Pattern pattern, String interval, TimeUnit nanoseconds) {
        this.metricsRegistry = metricRegistry;
        this.sessionName = sessionName;
        this.prefix = prefix;
        this.pattern = pattern;
        this.interval = interval;
        this.nanoseconds = nanoseconds;
    }

    @Override
    public void onCapableAdded(String name, TimerAttachment capable) {
        if (this.pattern.matcher(name).matches()) {
            String prefixed = this.prefix + "-" + name;
            Timer classicTimer = new Timer((Reservoir)new ExponentiallyDecayingReservoir());
            capable.attachTimer(classicTimer);
            this.histos.put(prefixed, new Attachment(name, this.prefix, capable, classicTimer));
            this.metricsRegistry.timer(prefixed, () -> classicTimer);
            logger.trace(() -> "Added classic timer attachment:" + prefixed);
        }
    }

    @Override
    public void onCapableRemoved(String name, TimerAttachment capable) {
        Attachment removed = this.histos.remove(name);
        logger.trace(() -> "Removed classic timer attachment: " + removed);
    }

    @Override
    protected Class<TimerAttachment> getCapabilityClass() {
        return TimerAttachment.class;
    }

    private static class Attachment {
        public final String upstreamName;
        public final TimerAttachment upstream;
        public Timer downstream;
        public String prefix;

        public Attachment(String upstreamName, String prefix, TimerAttachment upstream, Timer downstream) {
            this.prefix = prefix;
            this.upstreamName = upstreamName;
            this.upstream = upstream;
            this.downstream = downstream;
        }

        public String toString() {
            return "name:" + this.upstreamName + "->" + this.prefix + "-" + this.upstreamName;
        }

        public String getName() {
            return this.upstreamName;
        }
    }
}

