/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.engine.metrics;

import io.nosqlbench.api.engine.metrics.CapabilityHook;
import io.nosqlbench.api.engine.metrics.HdrDeltaHistogramAttachment;
import io.nosqlbench.api.engine.metrics.HdrDeltaHistogramProvider;
import io.nosqlbench.api.engine.metrics.HistoLogChartGenerator;
import io.nosqlbench.api.engine.metrics.MetricsCloseable;
import io.nosqlbench.api.engine.metrics.PeriodicRunnable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.HistogramLogWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HistoIntervalLogger
extends CapabilityHook<HdrDeltaHistogramAttachment>
implements Runnable,
MetricsCloseable {
    private static final Logger logger = LogManager.getLogger(HistoIntervalLogger.class);
    private final String sessionName;
    private final long intervalLength;
    private final File logfile;
    private PrintStream logStream;
    private HistogramLogWriter writer;
    private final Pattern pattern;
    private final List<WriterTarget> targets = new CopyOnWriteArrayList<WriterTarget>();
    private PeriodicRunnable<HistoIntervalLogger> executor;
    private long lastRunTime;

    public File getLogfile() {
        return this.logfile;
    }

    public HistoIntervalLogger(String sessionName, File file, Pattern pattern, long intervalLength) {
        this.sessionName = sessionName;
        this.logfile = file;
        this.pattern = pattern;
        this.intervalLength = intervalLength;
        this.startLogging();
    }

    public boolean matches(String metricName) {
        return this.pattern.matcher(metricName).matches();
    }

    public void startLogging() {
        try {
            this.logStream = new PrintStream(this.logfile);
            this.writer = new HistogramLogWriter(this.logStream);
            this.writer.outputComment("logging histograms for session " + this.sessionName);
            this.writer.outputLogFormatVersion();
            long currentTimeMillis = System.currentTimeMillis();
            this.writer.outputStartTime(currentTimeMillis);
            this.writer.setBaseTime(currentTimeMillis);
            this.writer.outputLegend();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error while starting histogram log writer", e);
        }
        this.executor = new PeriodicRunnable<HistoIntervalLogger>(this.getInterval(), this);
        this.executor.startDaemonThread();
    }

    public String toString() {
        return "HistoLogger:" + this.pattern + ":" + this.logfile.getPath() + ":" + this.intervalLength;
    }

    public long getInterval() {
        return this.intervalLength;
    }

    @Override
    public synchronized void onCapableAdded(String name, HdrDeltaHistogramAttachment chainedHistogram) {
        if (this.pattern.matcher(name).matches()) {
            this.targets.add(new WriterTarget(name, chainedHistogram.attachHdrDeltaHistogram()));
        }
    }

    @Override
    public synchronized void onCapableRemoved(String name, HdrDeltaHistogramAttachment capable) {
        this.targets.remove(new WriterTarget(name, null));
    }

    @Override
    protected Class<HdrDeltaHistogramAttachment> getCapabilityClass() {
        return HdrDeltaHistogramAttachment.class;
    }

    @Override
    public void run() {
        for (WriterTarget target : this.targets) {
            this.writer.outputIntervalHistogram((EncodableHistogram)target.histoProvider.getNextHdrDeltaHistogram());
        }
        this.lastRunTime = System.currentTimeMillis();
    }

    @Override
    public void closeMetrics() {
        this.executor.close();
        long potentialWriteTime = System.currentTimeMillis();
        if (this.lastRunTime + 1000L < potentialWriteTime) {
            logger.debug(() -> "Writing last partial histo log:" + this);
            this.run();
        } else {
            logger.debug("Not writing last partial histo log <1s:" + this);
        }
        this.logStream.close();
    }

    @Override
    public void chart() {
        HistoLogChartGenerator.generateChartFromHistoLog(this);
    }

    private static class WriterTarget
    implements Comparable<WriterTarget> {
        public String name;
        public HdrDeltaHistogramProvider histoProvider;

        public WriterTarget(String name, HdrDeltaHistogramProvider attach) {
            this.name = name;
            this.histoProvider = attach;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((WriterTarget)obj).name);
        }

        @Override
        public int compareTo(WriterTarget obj) {
            return this.name.compareTo(obj.name);
        }
    }
}

