/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.engine.metrics;

import io.nosqlbench.api.engine.metrics.CapabilityHook;
import io.nosqlbench.api.engine.metrics.HdrDeltaHistogramAttachment;
import io.nosqlbench.api.engine.metrics.HdrDeltaHistogramProvider;
import io.nosqlbench.api.engine.metrics.HistoStatsCSVWriter;
import io.nosqlbench.api.engine.metrics.MetricsCloseable;
import io.nosqlbench.api.engine.metrics.PeriodicRunnable;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.HdrHistogram.Histogram;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HistoStatsLogger
extends CapabilityHook<HdrDeltaHistogramAttachment>
implements Runnable,
MetricsCloseable {
    private static final Logger logger = LogManager.getLogger(HistoStatsLogger.class);
    private final String sessionName;
    private final TimeUnit timeUnit;
    private final long intervalLength;
    private final File logfile;
    private HistoStatsCSVWriter writer;
    private final Pattern pattern;
    private final List<WriterTarget> targets = new CopyOnWriteArrayList<WriterTarget>();
    private PeriodicRunnable<HistoStatsLogger> executor;
    private long lastRunTime = 0L;

    public HistoStatsLogger(String sessionName, File file, Pattern pattern, long intervalLength, TimeUnit timeUnit) {
        this.sessionName = sessionName;
        this.logfile = file;
        this.pattern = pattern;
        this.intervalLength = intervalLength;
        this.timeUnit = timeUnit;
        this.startLogging();
    }

    public boolean matches(String metricName) {
        return this.pattern.matcher(metricName).matches();
    }

    public void startLogging() {
        this.writer = new HistoStatsCSVWriter(this.logfile);
        this.writer.outputComment("logging stats for session " + this.sessionName);
        this.writer.outputLogFormatVersion();
        long currentTimeMillis = System.currentTimeMillis();
        this.writer.outputStartTime(currentTimeMillis);
        this.writer.outputTimeUnit(this.timeUnit);
        this.writer.setBaseTime(currentTimeMillis);
        this.writer.outputLegend();
        this.executor = new PeriodicRunnable<HistoStatsLogger>(this.getInterval(), this);
        this.executor.startDaemonThread();
    }

    public String toString() {
        return "HistoLogger:" + this.pattern + ":" + this.logfile.getPath() + ":" + this.intervalLength;
    }

    public long getInterval() {
        return this.intervalLength;
    }

    @Override
    public void onCapableAdded(String name, HdrDeltaHistogramAttachment chainedHistogram) {
        if (this.pattern.matcher(name).matches()) {
            this.targets.add(new WriterTarget(name, chainedHistogram.attachHdrDeltaHistogram()));
        }
    }

    @Override
    public void onCapableRemoved(String name, HdrDeltaHistogramAttachment capable) {
        this.targets.remove(new WriterTarget(name, null));
    }

    @Override
    protected Class<HdrDeltaHistogramAttachment> getCapabilityClass() {
        return HdrDeltaHistogramAttachment.class;
    }

    @Override
    public void run() {
        for (WriterTarget target : this.targets) {
            Histogram nextHdrHistogram = target.histoProvider.getNextHdrDeltaHistogram();
            this.writer.writeInterval(nextHdrHistogram);
        }
        this.lastRunTime = System.currentTimeMillis();
    }

    @Override
    public void closeMetrics() {
        long now = System.currentTimeMillis();
        if (this.lastRunTime + 1000L < now) {
            logger.debug("Writing last partial interval: " + this);
            this.run();
        } else {
            logger.debug("Not writing last partial interval <1s: " + this);
        }
    }

    @Override
    public void chart() {
    }

    private static class WriterTarget
    implements Comparable<WriterTarget> {
        public String name;
        public HdrDeltaHistogramProvider histoProvider;

        public WriterTarget(String name, HdrDeltaHistogramProvider attach) {
            this.name = name;
            this.histoProvider = attach;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((WriterTarget)obj).name);
        }

        @Override
        public int compareTo(WriterTarget obj) {
            return this.name.compareTo(obj.name);
        }
    }
}

