/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.errors;

import io.nosqlbench.api.errors.ActivityInitError;

public class OpConfigError
extends ActivityInitError {
    private final String configSource;

    public OpConfigError(String error) {
        this(error, null, null);
    }

    public OpConfigError(String error, Throwable cause) {
        this(error, null, cause);
    }

    public OpConfigError(String error, String configSource) {
        super(error);
        this.configSource = configSource;
    }

    public OpConfigError(String error, String configSource, Throwable cause) {
        super(error, cause);
        this.configSource = configSource;
    }

    public String getCfgSrc() {
        return this.configSource;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Error while configuring op from workload template:");
        String cfgsrc = this.configSource;
        if (cfgsrc == null) {
            Throwable cause = this.getCause();
            while (cause instanceof OpConfigError && cfgsrc == null) {
                cfgsrc = ((OpConfigError)cause).getCfgSrc();
                cause = cause.getCause();
            }
        }
        if (cfgsrc != null) {
            sb.append(" [from:" + this.configSource + "] ");
        }
        if (this.getCause() != null) {
            sb.append(" cause: " + this.getCause().getClass().getSimpleName() + ":" + this.getCause().getMessage());
        }
        if (super.getMessage() != null) {
            sb.append(" " + super.getMessage());
        }
        return sb.toString();
    }
}

