/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public interface Labeled {
    public Map<String, String> getLabels();

    default public Map<String, String> getLabelsAnd(String ... keyvalues) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.getLabels());
        for (int idx = 0; idx < keyvalues.length; idx += 2) {
            map.put(keyvalues[idx], keyvalues[idx + 1]);
        }
        return map;
    }

    default public Map<String, String> getLabelsAnd(Map<String, String> extra) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.getLabels());
        map.putAll(extra);
        return map;
    }

    public static MapLabels forMap(Map<String, String> labels) {
        return new MapLabels(labels);
    }

    default public String linearized(Map<String, String> and) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> allLabels = this.getLabelsAnd(and);
        ArrayList<String> sortedLabels = new ArrayList<String>(allLabels.keySet());
        Collections.sort(sortedLabels);
        for (String label : sortedLabels) {
            sb.append(label).append(":").append(allLabels.get(label)).append(",");
        }
        sb.setLength(sb.length() - ",".length());
        return sb.toString();
    }

    default public String linearized(String ... and) {
        return this.linearized(this.getLabelsAnd(and));
    }

    public static class MapLabels
    implements Labeled {
        private final Map<String, String> labels;

        public MapLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        @Override
        public Map<String, String> getLabels() {
            return this.labels;
        }
    }
}

