/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.markdown.aggregator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;

public class MutableFrontMatter
extends LinkedHashMap<String, List<String>> {
    String WEIGHT = "weight";
    String TITLE = "title";

    MutableFrontMatter(Map<String, List<String>> data) {
        this.putAll(data);
    }

    public String getTitle() {
        this.assertMaxSingleValued(this.TITLE);
        return Optional.ofNullable((List)this.get(this.TITLE)).map(l -> (String)l.get(0)).orElse(null);
    }

    public int getWeight() {
        this.assertMaxSingleValued(this.WEIGHT);
        return Optional.ofNullable((List)this.get(this.WEIGHT)).map(l -> (String)l.get(0)).map(Integer::parseInt).orElse(0);
    }

    public void setTitle(String title) {
        this.put(this.TITLE, List.of(title));
    }

    public void setWeight(int weight) {
        this.put(this.WEIGHT, List.of(String.valueOf(weight)));
    }

    private void assertMaxSingleValued(String fieldname) {
        if (this.containsKey(fieldname) && ((List)this.get(fieldname)).size() > 1) {
            throw new RuntimeException("Field '" + fieldname + "' can only have zero or one value. It is single-valued.");
        }
    }

    public String asYaml() {
        DumpSettings settings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).build();
        Dump dump = new Dump(settings);
        return dump.dumpToString(Map.of(this.TITLE, this.getTitle(), this.WEIGHT, this.getWeight()));
    }
}

