/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.markdown.aggregator;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import io.nosqlbench.api.markdown.FlexParser;
import io.nosqlbench.api.markdown.aggregator.MarkdownDocs;
import io.nosqlbench.api.markdown.aggregator.MutableFrontMatter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MutableMarkdown {
    private static final Logger logger = LogManager.getLogger(MarkdownDocs.class);
    private MutableFrontMatter frontMatter;
    private final String rawMarkdown;
    private final Path path;
    private Heading firstHeading;

    public MutableMarkdown(Path path) {
        try {
            this.path = path;
            this.rawMarkdown = Files.readString(path);
            this.parseStructure(this.rawMarkdown);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableMarkdown(String rawMarkdown) {
        this.path = null;
        this.rawMarkdown = rawMarkdown;
        this.parseStructure(rawMarkdown);
    }

    private void parseStructure(String rawMarkdown) {
        AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
        Document parsed = FlexParser.parser.parse(rawMarkdown);
        v.visit((Node)parsed);
        Map data = v.getData();
        this.frontMatter = new MutableFrontMatter(data);
        if (this.frontMatter.getTitle() == null || this.frontMatter.getTitle().isEmpty()) {
            for (Node node = parsed.getFirstChild(); node != null; node = node.getNext()) {
                if (node instanceof Heading) {
                    this.frontMatter.setTitle(((Heading)node).getText().toString());
                    break;
                }
                if (node instanceof BlankLine || node instanceof WhiteSpace || node instanceof YamlFrontMatterBlock) continue;
                if (this.path != null) {
                    throw new RuntimeException("The markdown file at '" + this.path.toString() + "' must have an initial heading as a title, before any other element, but found:" + node.getClass().getSimpleName());
                }
                throw new RuntimeException("The markdown string provided must have an initial heading as a title, before any other element, but found: " + node.getClass().getSimpleName());
            }
        }
        if (this.frontMatter.getTitle() == null || this.frontMatter.getTitle().isEmpty()) {
            if (this.path != null) {
                throw new RuntimeException("The markdown file at '" + this.path.toString() + "' has no heading to use as a title.");
            }
            throw new RuntimeException("The markdown string provided has no heading to use as a title.");
        }
    }

    public Path getPath() {
        return this.path;
    }

    public String getBody() {
        for (String boundary : List.of("---\n", "+++\n")) {
            if (!this.rawMarkdown.startsWith(boundary)) continue;
            int end = this.rawMarkdown.indexOf(boundary, 3);
            if (end >= 0) {
                return this.rawMarkdown.substring(end + 4);
            }
            if (this.path != null) {
                throw new RuntimeException("Unable to find matching boundaries in " + this.path.toString() + ": " + boundary);
            }
            throw new RuntimeException("Unable to find matching boundaries in provided markdown: " + boundary);
        }
        return this.rawMarkdown;
    }

    public MutableFrontMatter getFrontmatter() {
        return this.frontMatter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "/" + this.frontMatter.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableMarkdown that = (MutableMarkdown)o;
        return Objects.equals(this.frontMatter, that.frontMatter) && Objects.equals(this.rawMarkdown, that.rawMarkdown);
    }

    public int hashCode() {
        return Objects.hash(this.frontMatter, this.rawMarkdown);
    }

    public String getComposedMarkdown() {
        StringBuilder sb = new StringBuilder();
        sb.append("---\n");
        sb.append(this.frontMatter.asYaml());
        sb.append("---\n");
        sb.append(this.getBody());
        return sb.toString();
    }
}

