/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.markdown.aggregator;

import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.markdown.FlexParser;
import io.nosqlbench.api.markdown.aggregator.MarkdownDocs;
import io.nosqlbench.api.markdown.aggregator.ParsedFrontMatter;
import io.nosqlbench.api.markdown.types.FrontMatterInfo;
import io.nosqlbench.api.markdown.types.HasDiagnostics;
import io.nosqlbench.api.markdown.types.MarkdownInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParsedMarkdown
implements MarkdownInfo,
HasDiagnostics {
    private static final Logger logger = LogManager.getLogger(MarkdownDocs.class);
    private final ParsedFrontMatter frontMatter;
    private final Content<?> content;

    public ParsedMarkdown(Content<?> content) {
        String rawMarkdown = content.asString();
        AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
        Document parsed = FlexParser.parser.parse(rawMarkdown);
        v.visit((Node)parsed);
        Map data = v.getData();
        this.frontMatter = new ParsedFrontMatter(data);
        this.content = content;
        logger.debug("created " + this);
    }

    private ParsedMarkdown(ParsedFrontMatter frontMatter, Content<?> content) {
        this.frontMatter = frontMatter;
        this.content = content;
    }

    @Override
    public Path getPath() {
        return this.content.asPath();
    }

    @Override
    public String getBody() {
        return null;
    }

    @Override
    public FrontMatterInfo getFrontmatter() {
        return this.frontMatter;
    }

    @Override
    public List<String> getDiagnostics(List<String> buffer) {
        List<String> diagnostics = this.frontMatter.getDiagnostics();
        if (diagnostics.size() == 0) {
            return List.of();
        }
        String[] diags = (String[])diagnostics.stream().map(s -> " " + s).toArray(String[]::new);
        buffer.add("found " + diagnostics.size() + " diagnostics for " + this.getPath().toString());
        buffer.addAll(Arrays.asList(diags));
        return buffer;
    }

    @Override
    public List<String> getDiagnostics() {
        return this.getDiagnostics(new ArrayList<String>());
    }

    @Override
    public boolean hasAggregations() {
        return this.getFrontmatter().getAggregations().size() > 0;
    }

    @Override
    public MarkdownInfo withTopics(List<String> assigning) {
        return new ParsedMarkdown(this.frontMatter.withTopics(assigning), this.content);
    }

    @Override
    public MarkdownInfo withIncluded(List<String> included) {
        return new ParsedMarkdown(this.frontMatter.withIncluded(included), this.content);
    }

    public String toString() {
        return "ParsedMarkdown/" + this.frontMatter.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedMarkdown that = (ParsedMarkdown)o;
        return Objects.equals(this.frontMatter, that.frontMatter) && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.frontMatter, this.content);
    }
}

