/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.markdown.exporter;

import io.nosqlbench.api.apps.BundledApp;
import io.nosqlbench.api.markdown.aggregator.MarkdownDocs;
import io.nosqlbench.api.markdown.types.DocScope;
import io.nosqlbench.api.markdown.types.MarkdownInfo;
import io.nosqlbench.nb.annotations.Service;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

@Service(value=BundledApp.class, selector="markdown-exporter")
public class MarkdownExporter
implements BundledApp,
Runnable {
    public static final String APP_NAME = "exporter";
    private Path basePath;
    private Set<DocScope> scopeSet;

    public static void main(String[] args) {
        new MarkdownExporter().applyAsInt(args);
    }

    @Override
    public void run() {
        List<MarkdownInfo> markdownInfos = MarkdownDocs.find(new ArrayList<DocScope>(this.scopeSet).toArray(new DocScope[0]));
    }

    @Override
    public int applyAsInt(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec basedir = parser.accepts("basedir", "base directory to write to").withRequiredArg().ofType(String.class).defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec docScopes = parser.accepts("scopes", "scopes of documentation to export").withRequiredArg().ofType(String.class).defaultsTo((Object)DocScope.ANY.toString(), (Object[])new String[0]);
        parser.acceptsAll(List.of("-h", "--help", "help"), "Display help").forHelp();
        OptionSet options = parser.parse(args);
        Path basePath = Path.of((String)basedir.value(options), new String[0]);
        Set scopeSet = docScopes.values(options).stream().map(DocScope::valueOf).collect(Collectors.toSet());
        this.basePath = basePath;
        this.scopeSet = scopeSet;
        this.run();
        return 0;
    }
}

