/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.markdown.types;

import io.nosqlbench.api.markdown.types.FrontMatterInfo;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface MarkdownInfo
extends Comparable<MarkdownInfo> {
    public Path getPath();

    public String getBody();

    public FrontMatterInfo getFrontmatter();

    public boolean hasAggregations();

    default public boolean hasTopicGlobs() {
        return this.getTopicGlobs().size() > 0;
    }

    default public List<Pattern> getTopicGlobs() {
        List<Pattern> pattern = this.getFrontmatter().getTopics().stream().filter(t -> t.startsWith("^") || t.endsWith("$") || t.contains(".*") || t.contains(".+")).map(Pattern::compile).collect(Collectors.toList());
        return pattern;
    }

    default public List<String> getTopics() {
        return this.getFrontmatter().getTopics().stream().filter(t -> !t.startsWith("^") && !t.endsWith("$") && !t.contains(".*") && !t.contains(".+")).collect(Collectors.toList());
    }

    default public List<String> getIncluded() {
        return this.getFrontmatter().getIncluded();
    }

    default public boolean hasAggregators() {
        return this.getFrontmatter().getAggregations().size() > 0;
    }

    default public List<Pattern> getAggregators() {
        return this.getFrontmatter().getAggregations();
    }

    public MarkdownInfo withTopics(List<String> var1);

    @Override
    default public int compareTo(@NotNull MarkdownInfo o) {
        int diff = this.getFrontmatter().getWeight() - o.getFrontmatter().getWeight();
        if (diff != 0) {
            return diff;
        }
        diff = this.getFrontmatter().getTitle().compareTo(o.getFrontmatter().getTitle());
        if (diff != 0) {
            return diff;
        }
        diff = this.getBody().compareTo(o.getBody());
        return diff;
    }

    default public boolean matchesTopicPattern(Pattern pattern) {
        return this.getTopics().stream().anyMatch(t -> pattern.matcher((CharSequence)t).matches());
    }

    public MarkdownInfo withIncluded(List<String> var1);
}

