/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class SystemId {
    public static String getNodeId() {
        SystemInfo sysinfo = new SystemInfo();
        HardwareAbstractionLayer hal = sysinfo.getHardware();
        List interfaces = hal.getNetworkIFs();
        Optional<String> first = interfaces.stream().filter(i -> !i.getName().startsWith("docker")).filter(i -> !i.getName().equals("lo")).sorted((o1, o2) -> {
            if (o1.getName().startsWith("e") && o2.getName().startsWith("e")) {
                return 0;
            }
            if (o1.getName().startsWith("e")) {
                return -1;
            }
            if (o2.getName().startsWith("e")) {
                return 1;
            }
            return 0;
        }).flatMap(iface -> Arrays.stream((String[])iface.getIPv4addr().clone())).filter(addr -> !addr.startsWith("127.")).findFirst();
        String systemID = first.orElse("UNKNOWN_SYSTEM_ID");
        return systemID;
    }

    public static String getNodeFingerprint() {
        String addrId = SystemId.getNodeId();
        try {
            MessageDigest sha1_digest = MessageDigest.getInstance("SHA-1");
            byte[] addrBytes = sha1_digest.digest(addrId.getBytes(StandardCharsets.UTF_8));
            Object fingerprint = "";
            for (int i = 0; i < addrBytes.length; ++i) {
                fingerprint = (String)fingerprint + Integer.toString((addrBytes[i] & 0xFF) + 256, 16).substring(1);
            }
            return ((String)fingerprint).toUpperCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHostSummary() {
        SystemInfo sysinfo = new SystemInfo();
        HardwareAbstractionLayer hal = sysinfo.getHardware();
        CentralProcessor p = hal.getProcessor();
        Gson gson = new GsonBuilder().create();
        HashSet ifspeeds = new HashSet();
        hal.getNetworkIFs().forEach(x -> {
            long spd = x.getSpeed();
            if (spd < 1048576000L) {
                ifspeeds.add(String.format("%.0fMib", spd / 0x100000L));
            } else {
                ifspeeds.add(String.format("%.0fGib", spd / 1048576000L));
            }
        });
        Map details = Map.of("physical-cores", String.valueOf(p.getPhysicalProcessorCount()), "logical-cores", String.valueOf(p.getLogicalProcessors().size()), "max-frequency-ghz", String.format("%.2f", (double)p.getMaxFreq() / 1.0E12), "sockets", String.valueOf(p.getPhysicalPackageCount()), "processor-name", String.valueOf(p.getProcessorIdentifier().getName()), "memory-GiB", String.format("%.2f", (double)hal.getMemory().getTotal() / 1.073741824E9), "heap-max-GiB", String.format("%.2f", (double)Runtime.getRuntime().maxMemory() / 1.073741824E9), "if-speeds", ifspeeds);
        return gson.toJson(details);
    }
}

