/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.spi;

import io.nosqlbench.nb.annotations.Maturity;
import io.nosqlbench.nb.annotations.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleServiceLoader<T> {
    private static final Logger logger = LogManager.getLogger((String)"SERVICESAPI");
    private final Class<? extends T> serviceType;
    private Maturity maturity = Maturity.Unspecified;

    public SimpleServiceLoader(Class<? extends T> serviceType, Maturity maturity) {
        this.serviceType = serviceType;
        this.maturity = maturity;
    }

    public SimpleServiceLoader setMaturity(Maturity maturity) {
        this.maturity = maturity;
        return this;
    }

    public Optional<T> get(String implName) {
        List<Component<T>> namedProviders = this.getNamedProviders(new String[0]);
        if (namedProviders == null) {
            return Optional.empty();
        }
        List<Component> components = namedProviders.stream().filter(n -> n.selector.equals(implName)).toList();
        if (components.size() > 1) {
            throw new RuntimeException("Found multiple components matching '" + implName + "',");
        }
        if (components.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(components.get((int)0).provider.get());
    }

    public T getOrThrow(String implName) {
        Optional<T> t = this.get(implName);
        return t.orElseThrow(() -> new RuntimeException(this.serviceType.getSimpleName() + " '" + implName + "' not found. Available types:" + this.getNamedProviders(new String[0])));
    }

    public Optional<T> getOptionally(String implName) {
        Optional<T> type = this.get(implName);
        return type;
    }

    public synchronized List<Component<? extends T>> getNamedProviders(String ... includes) {
        ServiceLoader<T> loader = ServiceLoader.load(this.serviceType);
        List<String> defaultedPatterns = includes != null && includes.length > 0 ? Arrays.asList(includes) : List.of(".*");
        List qualifiedPatterns = defaultedPatterns.stream().map(Pattern::compile).collect(Collectors.toList());
        ArrayList components = new ArrayList();
        loader.stream().forEach(provider -> {
            logger.trace("loading provider: " + provider.type());
            Class type = provider.type();
            if (!type.isAnnotationPresent(Service.class)) {
                throw new RuntimeException("Annotator services must be annotated with distinct selectors\nsuch as @Service(Annotator.class,selector=\"myimpl42\")");
            }
            Service service = type.getAnnotation(Service.class);
            for (Pattern pattern : qualifiedPatterns) {
                if (!pattern.matcher(service.selector()).matches()) continue;
                components.add(new Component(service.selector(), provider, service.maturity()));
                break;
            }
        });
        return components;
    }

    public Map<String, Maturity> getAllSelectors(String ... patterns) {
        LinkedHashMap<String, Maturity> map = new LinkedHashMap<String, Maturity>();
        for (Component<T> namedProvider : this.getNamedProviders(patterns)) {
            map.put(namedProvider.selector, namedProvider.maturity);
        }
        return map;
    }

    public static final class Component<T> {
        public final String selector;
        public final ServiceLoader.Provider<? extends T> provider;
        public final Maturity maturity;

        public Component(String selector, ServiceLoader.Provider<? extends T> provider, Maturity maturity) {
            this.selector = selector;
            this.provider = provider;
            this.maturity = maturity;
        }

        public String toString() {
            return "Component{" + this.selector + " (" + this.maturity + ")";
        }
    }
}

