/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.api.testutils;

public class Bounds {
    private final int levelsPerMagnitude;
    private long currentValue;

    public Bounds(long startingValue, int levelsPerMagnitude) {
        this.currentValue = startingValue;
        this.levelsPerMagnitude = levelsPerMagnitude;
    }

    public Bounds setValue(long value) {
        this.currentValue = value;
        return this;
    }

    public long getValue() {
        return this.currentValue;
    }

    public long getNextValue() {
        long nextValue;
        this.currentValue = nextValue = this.findNextHigherValue();
        return this.currentValue;
    }

    private long findNextHigherValue() {
        int pow10 = (int)Math.log10(this.currentValue);
        if (this.levelsPerMagnitude == 1) {
            return (long)Math.pow(10.0, pow10 + 1);
        }
        double baseMagnitude = Math.pow(10.0, pow10);
        double increment = baseMagnitude / (double)this.levelsPerMagnitude;
        long newValue = (long)((double)this.currentValue + increment);
        return newValue;
    }

    public String toString() {
        return this.currentValue + "(incr by 1/" + this.levelsPerMagnitude + ")";
    }
}

