/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api.bindings;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.bindings.NBFunctionConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class VirtDataConversions {
    public static <F, T> List<T> adaptFunctionList(F[] funcs, Class<T> functionType, Class<Object> ... resultSignature) {
        ArrayList<T> functions = new ArrayList<T>();
        for (F func : funcs) {
            T adapted = VirtDataConversions.adaptFunction(func, functionType, resultSignature);
            functions.add(adapted);
        }
        return functions;
    }

    public static <F, T> T adaptFunction(F func, Class<T> functionType, Class<?> ... resultSignature) {
        FuncType funcType = FuncType.valueOf(func.getClass());
        ArrayList signature = new ArrayList();
        List<Class<?>> fromSignature = VirtDataConversions.linearizeObjectSignature(func);
        ArrayList resultTypes = new ArrayList();
        resultTypes.add(functionType);
        for (Class<?> aClass : resultSignature) {
            resultTypes.add(aClass);
        }
        List<Class<?>> toSignature = VirtDataConversions.linearizeSignature(resultTypes);
        signature.addAll(fromSignature);
        signature.addAll(toSignature);
        if (fromSignature.equals(toSignature)) {
            return (T)func;
        }
        if (VirtDataConversions.isAssignableFromTo(fromSignature, toSignature)) {
            return (T)func;
        }
        Class[] methodSignature = signature.toArray(new Class[0]);
        Method adapter = null;
        Class<NBFunctionConverter> hostclass = NBFunctionConverter.class;
        try {
            adapter = NBFunctionConverter.class.getMethod("adapt", methodSignature);
        }
        catch (NoSuchMethodException e) {
            StringBuilder example = new StringBuilder();
            example.append("    // Ignore the place holders in your implementation, but ensure the return type is accurate\n");
            String toTypeSyntax = VirtDataConversions.canonicalSyntaxFor(toSignature);
            example.append("    public static ").append(toTypeSyntax);
            example.append(" adapt(");
            String fromTypeSyntax = VirtDataConversions.canonicalSyntaxFor(fromSignature);
            example.append(fromTypeSyntax).append(" f");
            int idx = 1;
            for (int i = 1; i < signature.size(); ++i) {
                Class sigpart = (Class)signature.get(i);
                example.append(", ").append(sigpart.getSimpleName()).append(" i").append(idx++);
            }
            example.append(") {\n    }\n");
            String forInstance = example.toString();
            throw new BasicError("adapter method is not implemented on class " + hostclass.getCanonicalName() + ":\n" + forInstance);
        }
        FuncType fromType = FuncType.valueOf(func.getClass());
        if (fromType.functionClazz.getTypeParameters().length > 0) {
            TypeVariable<Class<?>>[] example = func.getClass().getTypeParameters();
        }
        Object[] args = new Object[signature.size()];
        args[0] = func;
        for (int i = 1; i < args.length; ++i) {
            args[i] = null;
        }
        Object result = null;
        try {
            result = adapter.invoke(null, args);
            return (T)result;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> getFunctions(int mod, int offset, Class<? extends T> functionType, Object ... funcs) {
        ArrayList<T> functions = new ArrayList<T>();
        for (int i = offset; i < funcs.length; i += mod) {
            Object func = funcs[i];
            T longFunction = VirtDataConversions.adaptFunction(func, functionType, Object.class);
            functions.add(longFunction);
        }
        return functions;
    }

    private static boolean isAssignableFromTo(List<Class<?>> fromSignature, List<Class<?>> toSignature) {
        if (fromSignature.size() != toSignature.size()) {
            return false;
        }
        for (int i = 0; i < fromSignature.size(); ++i) {
            Class<?> aClass0 = fromSignature.get(i);
            Class<?> aClass1 = toSignature.get(i);
            if (aClass1.isAssignableFrom(aClass0)) continue;
            return false;
        }
        return true;
    }

    private static List<Class<?>> linearizeSignature(Class<?> ... types) {
        ArrayList reified = new ArrayList();
        LinkedList provided = new LinkedList(Arrays.asList(types));
        while (provided.size() > 0) {
            Class<?> mainType = provided.removeFirst();
            FuncType funcType = FuncType.valueOf(mainType);
            reified.add(funcType.functionClazz);
            for (TypeVariable<Class<?>> typeParameter : funcType.functionClazz.getTypeParameters()) {
                if (provided.size() == 0) {
                    throw new RuntimeException("ran out of type parameters while qualifying generic parameter " + typeParameter.getName() + " for " + funcType.functionClazz);
                }
                Class<?> paramType = provided.remove();
                if (paramType.isPrimitive()) {
                    throw new RuntimeException("You must provide non primitive types for parameter positions here, not " + paramType.getCanonicalName());
                }
                reified.add(paramType);
            }
        }
        return reified;
    }

    private static List<Class<?>> linearizeSignature(List<Class<?>> types) {
        return VirtDataConversions.linearizeSignature(types.toArray(new Class[0]));
    }

    private static List<Class<?>> linearizeObjectSignature(Object f) {
        LinkedList linearized = new LinkedList();
        FuncType type = FuncType.valueOf(f.getClass());
        Class<?> functionClazz = type.functionClazz;
        linearized.add(functionClazz);
        TypeVariable<Class<?>>[] typeParameters = functionClazz.getTypeParameters();
        Method applyMethod = VirtDataConversions.findApplyMethod(functionClazz);
        switch (typeParameters.length) {
            case 2: {
                linearized.add(applyMethod.getParameterTypes()[0]);
            }
            case 1: {
                linearized.add(applyMethod.getReturnType());
            }
        }
        if (linearized.size() > 0 && ((Class)linearized.peekLast()).equals(Object.class)) {
            Object out = null;
            try {
                Class<?> input = applyMethod.getParameterTypes()[0];
                switch (input.getSimpleName()) {
                    case "int": 
                    case "Integer": {
                        out = applyMethod.invoke(f, 1);
                        break;
                    }
                    case "long": 
                    case "Long": {
                        out = applyMethod.invoke(f, 1L);
                        break;
                    }
                    case "double": 
                    case "Double": {
                        out = applyMethod.invoke(f, 1.0);
                        break;
                    }
                    default: {
                        out = Object.class;
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            linearized.removeLast();
            linearized.addLast(out.getClass());
        }
        return linearized;
    }

    private static String canonicalSyntaxFor(List<Class<?>> elements) {
        return VirtDataConversions.canonicalSyntaxFor(elements.toArray(new Class[0]));
    }

    private static String canonicalSyntaxFor(Class<?> ... elements) {
        StringBuilder sb = new StringBuilder();
        sb.append(elements[0].getSimpleName());
        if (elements.length > 1) {
            sb.append("<");
            for (int i = 1; i < elements.length; ++i) {
                sb.append(elements[i].getSimpleName()).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(">");
        }
        return sb.toString();
    }

    private static Method findApplyMethod(Class<?> c) {
        Optional<Method> applyMethods = Arrays.stream(c.getMethods()).filter(m -> {
            boolean isNotDefault = !m.isDefault();
            boolean isNotBridge = !m.isBridge();
            boolean isNotSynthetic = !m.isSynthetic();
            boolean isPublic = (m.getModifiers() & 1) > 0;
            boolean isNotString = !m.getName().equals("toString");
            boolean isApplyMethod = m.getName().startsWith("apply");
            boolean isFunctional = isNotDefault && isNotBridge && isNotSynthetic && isPublic && isNotString && isApplyMethod;
            return isFunctional;
        }).distinct().findFirst();
        return applyMethods.orElseThrow(() -> new RuntimeException("Unable to find apply method on " + c.getCanonicalName()));
    }

    private static Method findMethod(Class<?> hostclass, Class<?> fromClass, Class<?> toClass, Class<?> ... generics) {
        Class[] argTypes = new Class[generics.length + 2];
        argTypes[0] = fromClass;
        argTypes[1] = toClass;
        for (int i = 0; i < generics.length; ++i) {
            argTypes[i + 2] = generics[i];
        }
        try {
            return hostclass.getMethod("adapt", argTypes);
        }
        catch (NoSuchMethodException e) {
            StringBuilder example = new StringBuilder();
            StringBuilder genericsBuffer = new StringBuilder();
            TypeVariable<Class<?>>[] typeParameters = toClass.getTypeParameters();
            if (typeParameters.length > 0) {
                genericsBuffer.append("<");
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (generics.length < typeParameters.length) {
                        throw new RuntimeException("You must provide " + typeParameters.length + " generic parameter types for " + toClass.getCanonicalName());
                    }
                    genericsBuffer.append(generics[i].getSimpleName());
                    genericsBuffer.append(",");
                }
                genericsBuffer.setLength(genericsBuffer.length() - 1);
                genericsBuffer.append(">");
            }
            String genericSignature = genericsBuffer.toString();
            example.append("    // Ignore the place holders in your implementation, but ensure the return type is accurate\n");
            example.append("    public static ").append(toClass.getSimpleName());
            example.append(genericSignature);
            example.append(" adapt(");
            example.append(fromClass.getSimpleName()).append(" f, ");
            example.append(toClass.getSimpleName()).append(genericSignature).append(" ignore0");
            int idx = 1;
            for (Class<?> generic : generics) {
                example.append(", ").append(generic.getSimpleName()).append(" ignore").append(idx);
            }
            example.append(") {\n    }\n");
            String forInstance = example.toString();
            throw new BasicError("adapter method is not implemented on class " + hostclass.getCanonicalName() + ":\n" + forInstance);
        }
    }

    private static <T> T assertTypesAssignable(Object base, Class<T> wantType, Class<?> ... clazzes) {
        if (!wantType.isAssignableFrom(base.getClass())) {
            throw new InvalidParameterException("Unable to assign " + wantType.getCanonicalName() + " from " + base.getClass().getCanonicalName());
        }
        TypeVariable<Class<?>>[] typeParameters = base.getClass().getTypeParameters();
        if (typeParameters.length > 0) {
            if (clazzes.length != typeParameters.length) {
                throw new InvalidParameterException("type parameter lengths are mismatched:" + clazzes.length + ", " + typeParameters.length);
            }
            for (int i = 0; i < clazzes.length; ++i) {
                Class<?> from = clazzes[i];
                TypeVariable<Class<?>> to = typeParameters[i];
                boolean assignableFrom = to.getGenericDeclaration().isAssignableFrom(from);
                if (assignableFrom) continue;
                throw new InvalidParameterException("Can not assign " + from.getCanonicalName() + " to " + to.getGenericDeclaration().getCanonicalName());
            }
        }
        return (T)base;
    }

    private static enum FuncType {
        LongToDoubleFunction(LongToDoubleFunction.class, Long.TYPE, Double.TYPE),
        LongToIntFunction(LongToIntFunction.class, Long.TYPE, Integer.TYPE),
        LongFunction(LongFunction.class, Long.TYPE, Object.class),
        LongUnaryOperator(LongUnaryOperator.class, Long.TYPE, Long.TYPE),
        IntFunction(IntFunction.class, Integer.TYPE, Object.class),
        IntToDoubleFunction(IntToDoubleFunction.class, Integer.TYPE, Double.TYPE),
        IntToLongFunction(IntToLongFunction.class, Integer.TYPE, Long.TYPE),
        IntUnaryOperator(IntUnaryOperator.class, Integer.TYPE, Integer.TYPE),
        DoubleFunction(DoubleFunction.class, Double.TYPE, Object.class),
        DoubleUnaryOperator(DoubleUnaryOperator.class, Double.TYPE, Double.TYPE),
        DoubleToLongFunction(DoubleToLongFunction.class, Double.TYPE, Long.TYPE),
        DoubleToIntFunction(DoubleToIntFunction.class, Double.TYPE, Integer.TYPE),
        Function(Function.class, Object.class, Object.class);

        private final Class<?> functionClazz;
        private final Class<?> inputClazz;
        private final Class<?> outputClazz;

        private FuncType(Class<?> functionClazz, Class<?> inputClazz, Class<?> outputClazz) {
            this.functionClazz = functionClazz;
            this.inputClazz = inputClazz;
            this.outputClazz = outputClazz;
        }

        public static FuncType valueOf(Class<?> clazz) {
            for (FuncType value : FuncType.values()) {
                if (!value.functionClazz.isAssignableFrom(clazz)) continue;
                return value;
            }
            throw new InvalidParameterException("No func type was found for " + clazz.getCanonicalName());
        }
    }
}

