/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api.bindings;

import io.nosqlbench.nb.api.errors.BasicError;
import java.lang.reflect.TypeVariable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.apache.commons.lang3.ClassUtils;

public class VirtDataFunctions {
    public static <F> F adapt(Object func, Class<F> type, Class<?> output, boolean truncate) {
        FuncType funcType = FuncType.valueOf(type);
        switch (funcType) {
            case LongUnaryOperator: {
                return (F)(truncate ? VirtDataFunctions.adaptLongUnaryOperator(func, output) : VirtDataFunctions.adaptLongUnaryOperatorStrict(func, output));
            }
            case DoubleUnaryOperator: {
                return (F)(truncate ? VirtDataFunctions.adaptDoubleUnaryOperator(func, output) : VirtDataFunctions.adaptDoubleUnaryOperatorStrict(func, output));
            }
            case IntUnaryOperator: {
                return truncate ? VirtDataFunctions.adaptIntUnaryOperator(func, output) : VirtDataFunctions.adaptIntUnaryOperatorStrict(func, output);
            }
            case DoubleFunction: {
                return truncate ? VirtDataFunctions.adaptDoubleFunction(func, output) : VirtDataFunctions.adaptDoubleFunctionStrict(func, output);
            }
            case LongFunction: {
                return (F)(truncate ? VirtDataFunctions.adaptLongFunction(func, output) : VirtDataFunctions.adaptLongFunctionStrict(func, output));
            }
            case LongToDoubleFunction: {
                return (F)(truncate ? VirtDataFunctions.adaptLongToDoubleFunction(func, output) : VirtDataFunctions.adaptLongToDoubleFunctionStrict(func, output));
            }
            case LongToIntFunction: {
                return (F)(truncate ? VirtDataFunctions.adaptLongToIntFunction(func, output) : VirtDataFunctions.adaptLongFunctionStrict(func, output));
            }
            case IntFunction: {
                return VirtDataFunctions.adaptIntFunction(func, output);
            }
            case Function: {
                return (F)(truncate ? VirtDataFunctions.adaptFunction(func, output) : VirtDataFunctions.adaptFunctionStrict(func, output));
            }
        }
        throw new RuntimeException("Unable to convert function type '" + funcType + "' (" + func.getClass().getName() + ") to " + type.getName() + (truncate ? " WITH " : " WITHOUT ") + "truncation");
    }

    public static <F> List<F> adaptList(Object[] funcs, Class<F> type, Class<?> output, boolean truncate) {
        ArrayList<F> adapted = new ArrayList<F>();
        for (Object func : funcs) {
            F f = VirtDataFunctions.adapt(func, type, output, truncate);
            adapted.add(f);
        }
        return adapted;
    }

    private static LongToDoubleFunction adaptLongToDoubleFunctionStrict(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongToDoubleFunction: {
                LongToDoubleFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongToDoubleFunction.class, new Class[0]);
                return f1::applyAsDouble;
            }
            case LongToIntFunction: {
                LongToIntFunction f2 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                return f2::applyAsInt;
            }
            case LongFunction: {
                LongFunction f3 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Double.TYPE);
                return f3::apply;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f4 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return f4::applyAsLong;
            }
            case DoubleFunction: {
                DoubleFunction f7 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Double.TYPE);
                return f7::apply;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f8 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return f8::applyAsDouble;
            }
            case Function: {
                Function f9 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Double.TYPE, Double.TYPE);
                return l -> (Double)f9.apply(Double.valueOf(l));
            }
            case IntUnaryOperator: 
            case IntFunction: {
                VirtDataFunctions.throwNarrowingError(func, isaType.functionClazz);
            }
        }
        throw new BasicError("I don't know how to convert a " + func.getClass().getName() + " function to a LongToDoubleFunction.");
    }

    private static LongToDoubleFunction adaptLongToDoubleFunction(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongToDoubleFunction: {
                LongToDoubleFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongToDoubleFunction.class, new Class[0]);
                return null;
            }
            case LongToIntFunction: {
                LongToIntFunction f2 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                return null;
            }
            case LongFunction: {
                LongFunction f3 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Double.TYPE);
                return null;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f4 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return null;
            }
            case IntFunction: {
                IntFunction f5 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, Double.TYPE);
                return null;
            }
            case IntUnaryOperator: {
                IntUnaryOperator f6 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return null;
            }
            case DoubleFunction: {
                DoubleFunction f7 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Double.TYPE);
                return null;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f8 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return null;
            }
            case Function: {
                Function f9 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Double.TYPE, Double.TYPE);
                return null;
            }
        }
        throw new BasicError("I don't know how to convert a " + func.getClass().getName() + " function to a LongToDoubleFunction.");
    }

    private static LongFunction<?> adaptLongFunctionStrict(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Object.class);
                return f1;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f2 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return f2::applyAsLong;
            }
            case LongToIntFunction: {
                LongToIntFunction f3 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                return f3::applyAsInt;
            }
            case Function: {
                Function f7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Long.class);
                return l -> f7.apply(l);
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getName() + " to a " + LongUnaryOperator.class.getName() + " since this would cause a narrowing conversion.");
    }

    private static Function<?, ?> adaptFunction(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction f1 = (LongFunction)func;
                Function<Long, Object> rf1 = f1::apply;
                return rf1;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f2 = (LongUnaryOperator)func;
                Function<Long, Long> rf2 = f2::applyAsLong;
                return rf2;
            }
            case IntFunction: {
                IntFunction f3 = (IntFunction)func;
                Function<Integer, Object> rf3 = f3::apply;
                return rf3;
            }
            case IntUnaryOperator: {
                IntUnaryOperator f4 = (IntUnaryOperator)func;
                Function<Integer, Object> rf4 = f4::applyAsInt;
                return rf4;
            }
            case DoubleFunction: {
                DoubleFunction f5 = (DoubleFunction)func;
                Function<Double, Object> rf5 = f5::apply;
                return rf5;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f6 = (DoubleUnaryOperator)func;
                Function<Double, Object> rf6 = f6::applyAsDouble;
                return rf6;
            }
            case LongToIntFunction: {
                LongToIntFunction f7 = (LongToIntFunction)func;
                Function<Long, Integer> function = f7::applyAsInt;
            }
            case Function: {
                return (Function)func;
            }
        }
        throw new RuntimeException("Unable to map function:" + func);
    }

    private static <F> F adaptFunctionStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used: adaptFunctionsStrict(Object,Class<?>)");
    }

    private static <F> F adaptDoubleFunctionStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used: adaptDoubleFunctionStrict(Object,Class<?>) ");
    }

    private static <F> F adaptIntUnaryOperatorStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used: adaptIntUnaryOperatorStrict(Object,Class<?>)");
    }

    private static DoubleUnaryOperator adaptDoubleUnaryOperator(Object func, Class<?> output) {
        FuncType toFuncType = FuncType.valueOf(func.getClass());
        switch (toFuncType) {
            case DoubleFunction: {
                DoubleFunction f2 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Double.TYPE);
                return f2::apply;
            }
            case LongToDoubleFunction: {
                LongToDoubleFunction f3 = VirtDataFunctions.assertTypesAssignable(func, LongToDoubleFunction.class, new Class[0]);
                return l -> f3.applyAsDouble((long)l % Long.MAX_VALUE);
            }
            case LongToIntFunction: {
                LongToIntFunction f4 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                return l -> f4.applyAsInt((long)l % Long.MAX_VALUE);
            }
            case LongFunction: {
                LongFunction f5 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Double.TYPE);
                return l -> (Double)f5.apply((long)l % Long.MAX_VALUE);
            }
            case LongUnaryOperator: {
                LongUnaryOperator f6 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return l -> f6.applyAsLong((long)l % Long.MAX_VALUE);
            }
            case IntFunction: {
                IntFunction f7 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, Double.TYPE);
                return l -> (Double)f7.apply((int)l % Integer.MAX_VALUE);
            }
            case IntUnaryOperator: {
                IntUnaryOperator f8 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return l -> f8.applyAsInt((int)l % Integer.MAX_VALUE);
            }
            case DoubleToIntFunction: {
                DoubleToIntFunction f9 = VirtDataFunctions.assertTypesAssignable(func, DoubleToIntFunction.class, new Class[0]);
                return f9::applyAsInt;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator fA = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return fA;
            }
            case Function: {
                Function f1 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Double.TYPE, Double.TYPE);
                return f1::apply;
            }
        }
        throw new IllegalStateException("Unexpected value: " + toFuncType);
    }

    private static DoubleUnaryOperator adaptDoubleUnaryOperatorStrict(Object func, Class<?> output) {
        FuncType toFuncType = FuncType.valueOf(func.getClass());
        switch (toFuncType) {
            case Function: {
                Function f1 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Double.TYPE, Double.TYPE);
                return f1::apply;
            }
            case DoubleFunction: {
                DoubleFunction f2 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Double.TYPE);
                return f2::apply;
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getName() + " to a " + DoubleUnaryOperator.class.getName() + " since this would cause a narrowing conversion.");
    }

    private static LongUnaryOperator adaptLongUnaryOperatorStrict(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction o2 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Long.TYPE);
                return o2::apply;
            }
            case LongUnaryOperator: {
                LongUnaryOperator o5 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return o5;
            }
            case Function: {
                Function o7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Long.TYPE, Long.TYPE);
                return o7::apply;
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getName() + " to a " + LongUnaryOperator.class.getName() + " since this would cause a narrowing conversion.");
    }

    private static <F> F adaptIntFunction(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used: adaptIntFunction(Object,Class<?>)");
    }

    protected static LongToIntFunction adaptLongToIntFunction(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongToDoubleFunction: {
                LongToDoubleFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongToDoubleFunction.class, Double.TYPE);
                return l -> (int)(f1.applyAsDouble(l) % 2.147483647E9);
            }
            case LongToIntFunction: {
                LongToIntFunction f2 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                return f2;
            }
            case LongFunction: {
                LongFunction f3 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Double.TYPE);
                return l -> (int)((Double)f3.apply((int)l % Integer.MAX_VALUE)).longValue();
            }
            case LongUnaryOperator: {
                LongUnaryOperator f4 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return l -> (int)(f4.applyAsLong(l) % Integer.MAX_VALUE);
            }
            case IntFunction: {
                IntFunction f5 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, Double.TYPE);
                return l -> (int)((Long)f5.apply((int)l % Integer.MAX_VALUE)).longValue() % Integer.MAX_VALUE;
            }
            case IntUnaryOperator: {
                IntUnaryOperator f6 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return l -> f6.applyAsInt((int)l % Integer.MAX_VALUE);
            }
            case DoubleFunction: {
                DoubleFunction f7 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Double.TYPE);
                return l -> (int)((Double)f7.apply(l)).longValue() & Integer.MAX_VALUE;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f8 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return l -> (int)f8.applyAsDouble(l) % Integer.MAX_VALUE;
            }
            case Function: {
                Function f9 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Double.TYPE, Double.TYPE);
                return l -> (int)((Double)f9.apply(Double.valueOf(l))).longValue() % Integer.MAX_VALUE;
            }
        }
        throw new IllegalStateException("Unexpected value: " + isaType);
    }

    private static LongFunction<?> adaptLongFunction(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Object.class);
                return f1;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f2 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return f2::applyAsLong;
            }
            case IntFunction: {
                IntFunction f3 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, new Class[0]);
                return l -> f3.apply((int)(l % Integer.MAX_VALUE));
            }
            case IntUnaryOperator: {
                IntUnaryOperator f4 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return l -> f4.applyAsInt((int)(l % Integer.MAX_VALUE));
            }
            case DoubleFunction: {
                DoubleFunction f5 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, new Class[0]);
                return f5::apply;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f6 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return f6::applyAsDouble;
            }
            case Function: {
                Function f7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, new Class[0]);
                VirtDataFunctions.assertOutputAssignable(f7.apply(1L), output);
                return l -> f7.apply(l);
            }
            case LongToDoubleFunction: {
                LongToDoubleFunction f8 = VirtDataFunctions.assertTypesAssignable(func, LongToDoubleFunction.class, new Class[0]);
                return f8::applyAsDouble;
            }
            case LongToIntFunction: {
                LongToIntFunction f9 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                VirtDataFunctions.assertOutputAssignable(f9.applyAsInt(1L), output);
                return l -> f9.applyAsInt(l);
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getName() + " to a " + LongUnaryOperator.class.getName());
    }

    private static void assertOutputAssignable(Object result, Class<?> clazz) {
        if (!ClassUtils.isAssignable(result.getClass(), clazz, (boolean)true)) {
            throw new InvalidParameterException("Unable to assign type of " + result.getClass().getName() + " to " + clazz.getName());
        }
    }

    private static <F> F adaptDoubleFunction(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used: adaptDoubleFunction(Object,Class<?>)");
    }

    private static <F> F adaptIntUnaryOperator(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used: adaptIntUnaryOperator(Object,Class<?>)");
    }

    private static LongUnaryOperator adaptLongUnaryOperator(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case IntFunction: {
                IntFunction o1 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, Long.TYPE);
                return l -> (Long)o1.apply((int)l % Integer.MAX_VALUE);
            }
            case LongFunction: {
                LongFunction o2 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Long.TYPE);
                return o2::apply;
            }
            case DoubleFunction: {
                DoubleFunction o3 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Long.TYPE);
                return o3::apply;
            }
            case IntUnaryOperator: {
                IntUnaryOperator o4 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return l -> o4.applyAsInt((int)l % Integer.MAX_VALUE);
            }
            case LongUnaryOperator: {
                LongUnaryOperator o5 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return o5;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator o6 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return l -> (long)(o6.applyAsDouble(l) % 9.223372036854776E18);
            }
            case Function: {
                Function o7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Long.TYPE, Long.TYPE);
                return o7::apply;
            }
            case LongToDoubleFunction: {
                LongToDoubleFunction o8 = VirtDataFunctions.assertTypesAssignable(func, LongToDoubleFunction.class, new Class[0]);
                return l -> (long)o8.applyAsDouble(l % Long.MAX_VALUE) % Long.MAX_VALUE;
            }
            case LongToIntFunction: {
                LongToIntFunction o9 = VirtDataFunctions.assertTypesAssignable(func, LongToIntFunction.class, new Class[0]);
                return o9::applyAsInt;
            }
        }
        throw new InvalidParameterException("Unable to convert " + func.getClass().getName() + " to a " + LongUnaryOperator.class.getName());
    }

    private static <T> T assertTypesAssignable(Object base, Class<T> wantType, Class<?> ... clazzes) {
        if (!wantType.isAssignableFrom(base.getClass())) {
            throw new InvalidParameterException("Unable to assign " + wantType.getName() + " from " + base.getClass().getName());
        }
        TypeVariable<Class<?>>[] typeParameters = base.getClass().getTypeParameters();
        if (typeParameters.length > 0) {
            if (clazzes.length != typeParameters.length) {
                throw new InvalidParameterException("type parameter lengths are mismatched:" + clazzes.length + ", " + typeParameters.length);
            }
            for (int i = 0; i < clazzes.length; ++i) {
                Class<?> from = clazzes[i];
                TypeVariable<Class<?>> to = typeParameters[i];
                boolean assignableFrom = to.getGenericDeclaration().isAssignableFrom(from);
                if (assignableFrom) continue;
                throw new InvalidParameterException("Can not assign " + from.getName() + " to " + to.getGenericDeclaration().getName());
            }
        }
        return (T)base;
    }

    private static void throwNarrowingError(Object func, Class<?> targetClass) {
        throw new BasicError("Converting from " + func.getClass().getName() + " to " + targetClass.getName() + " is not allowed when strict conversion is requested.");
    }

    private static enum FuncType {
        LongToDoubleFunction(LongToDoubleFunction.class, Double.TYPE),
        LongToIntFunction(LongToIntFunction.class, Integer.TYPE),
        LongFunction(LongFunction.class, Long.TYPE),
        LongUnaryOperator(LongUnaryOperator.class, Long.TYPE),
        IntFunction(IntFunction.class, Integer.TYPE),
        IntUnaryOperator(IntUnaryOperator.class, Integer.TYPE),
        DoubleToIntFunction(DoubleToIntFunction.class, Integer.TYPE),
        DoubleFunction(DoubleFunction.class, Double.TYPE),
        DoubleUnaryOperator(DoubleUnaryOperator.class, Double.TYPE),
        Function(Function.class, Object.class);

        private final Class<?> functionClazz;
        private final Class<?> inputClazz;

        private FuncType(Class functionClazz, Class<?> example) {
            this.functionClazz = functionClazz;
            this.inputClazz = example;
        }

        public static FuncType valueOf(Class<?> clazz) {
            for (FuncType value : FuncType.values()) {
                if (!value.functionClazz.isAssignableFrom(clazz)) continue;
                return value;
            }
            throw new InvalidParameterException("No func type was found for " + clazz.getName());
        }
    }
}

