/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.bindings;

import io.nosqlbench.virtdata.core.bindings.Bindings;
import io.nosqlbench.virtdata.core.bindings.ResolverDiagnostics;
import io.nosqlbench.virtdata.core.bindings.VirtData;
import io.nosqlbench.virtdata.core.bindings.VirtDataDocs;
import io.nosqlbench.virtdata.core.templates.BindPoint;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BindingsTemplate {
    private static final Logger logger = LogManager.getLogger(BindingsTemplate.class);
    private final Map<String, Object> fconfig;
    private List<String> bindPointNames = new ArrayList<String>();
    private List<String> specifiers = new ArrayList<String>();

    public BindingsTemplate(Map<String, Object> config, List<String> anchors, List<String> specs) {
        this.fconfig = config;
        if (anchors.size() != specs.size()) {
            throw new InvalidParameterException("Anchors and Specifiers must be matched pair-wise.");
        }
        for (int i = 0; i < anchors.size(); ++i) {
            this.addFieldBinding(anchors.get(i), specs.get(i));
        }
    }

    public BindingsTemplate(Map<String, Object> config, List<BindPoint> bindpoints) {
        this.fconfig = config;
        this.addFieldBindings(bindpoints);
    }

    public BindingsTemplate(List<BindPoint> bindPoints) {
        this.fconfig = Map.of();
        this.addFieldBindings(bindPoints);
    }

    public BindingsTemplate(Map<String, Object> config) {
        this.fconfig = config;
    }

    public BindingsTemplate() {
        this.fconfig = Map.of();
    }

    public void addFieldBindings(List<BindPoint> bindPoints) {
        for (BindPoint bindPoint : bindPoints) {
            this.addFieldBinding(bindPoint.getAnchor(), bindPoint.getBindspec());
        }
    }

    public void addFieldBinding(String bindPointName, String genSpec) {
        this.bindPointNames.add(bindPointName);
        this.specifiers.add(genSpec);
    }

    public void addFieldBindings(Map<String, String> bindPairs) {
        for (Map.Entry<String, String> e : bindPairs.entrySet()) {
            this.bindPointNames.add(e.getKey());
            this.specifiers.add(e.getValue());
        }
    }

    public String getDiagnostics() {
        StringBuilder diaglog = new StringBuilder();
        for (String specifier : this.specifiers) {
            diaglog.append("for ").append(specifier).append(":");
            ResolverDiagnostics mapperDiagnostics = VirtData.getMapperDiagnostics(specifier);
            String diagnostics = mapperDiagnostics.toString();
            diaglog.append(diagnostics);
            if (mapperDiagnostics.getResolvedFunction().isPresent()) {
                diaglog.append("\u2611 RESOLVED:").append(mapperDiagnostics.getResolvedFunction().get().toString()).append("\n");
                continue;
            }
            diaglog.append("\u2610 UNRESOLVED\n");
        }
        return diaglog.toString();
    }

    public Bindings resolveBindings() {
        ArrayList dataMappers = new ArrayList();
        for (String specifier : this.specifiers) {
            Optional optionalDataMapper = VirtData.getOptionalMapper(specifier, this.fconfig);
            if (optionalDataMapper.isPresent()) {
                dataMappers.add(optionalDataMapper.get());
                continue;
            }
            this.logAvailableDataMappers();
            throw new RuntimeException("data mapper binding was unsuccessful for , spec:" + specifier + ", see log for known data mapper names.");
        }
        return new Bindings(this, dataMappers);
    }

    private void logAvailableDataMappers() {
        VirtDataDocs.getAllNames().forEach(gn -> logger.info("DATAMAPPER " + gn));
    }

    public List<String> getBindPointNames() {
        return this.bindPointNames;
    }

    public List<String> getDataMapperSpecs() {
        return this.specifiers;
    }

    public String toString() {
        String delim = "";
        StringBuilder sb = new StringBuilder(BindingsTemplate.class.getSimpleName()).append(":");
        for (int i = 0; i < this.bindPointNames.size(); ++i) {
            sb.append(delim);
            sb.append("'").append(this.bindPointNames.get(i)).append("'");
            sb.append("=>");
            sb.append("\"").append(this.specifiers.get(i)).append("\"");
            delim = ", ";
        }
        return sb.toString();
    }

    public String toString(Object[] values) {
        String delim = "";
        StringBuilder sb = new StringBuilder(BindingsTemplate.class.getSimpleName()).append(":");
        for (int i = 0; i < this.bindPointNames.size(); ++i) {
            sb.append(delim);
            sb.append("'").append(this.bindPointNames.get(i)).append("'");
            sb.append("=>");
            sb.append("\"").append(this.specifiers.get(i)).append("\"");
            sb.append("=>[");
            sb.append(values[i]);
            sb.append("](");
            sb.append(null != values[i] ? values[i].getClass().getSimpleName() : "NULL");
            sb.append(")");
            delim = ", ";
        }
        return sb.toString();
    }
}

