/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.bindings;

import io.nosqlbench.virtdata.core.bindings.BindingsTemplate;
import io.nosqlbench.virtdata.core.bindings.CompatibilityFixups;
import io.nosqlbench.virtdata.core.bindings.DataMapper;
import io.nosqlbench.virtdata.core.bindings.DataMapperFunctionMapper;
import io.nosqlbench.virtdata.core.bindings.FunctionTyper;
import io.nosqlbench.virtdata.core.bindings.ResolvedFunction;
import io.nosqlbench.virtdata.core.bindings.ResolverDiagnostics;
import io.nosqlbench.virtdata.core.bindings.ValueType;
import io.nosqlbench.virtdata.core.bindings.VirtDataComposer;
import io.nosqlbench.virtdata.core.templates.BindPoint;
import io.nosqlbench.virtdata.lang.ast.VirtDataFlow;
import io.nosqlbench.virtdata.lang.parser.VirtDataDSL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtData {
    private static final Logger logger = LogManager.getLogger(VirtData.class);

    public static BindingsTemplate getTemplate(Map<String, Object> config, String ... namesAndSpecs) {
        if (namesAndSpecs.length % 2 != 0) {
            throw new RuntimeException("args must be in 'name','spec', pairs. This can't be true for " + namesAndSpecs.length + "elements.");
        }
        ArrayList<BindPoint> bindPoints = new ArrayList<BindPoint>();
        for (int i = 0; i < namesAndSpecs.length; i += 2) {
            bindPoints.add(new BindPoint(namesAndSpecs[i], namesAndSpecs[i + 1], BindPoint.Type.definition));
        }
        return VirtData.getTemplate(config, bindPoints);
    }

    public static BindingsTemplate getTemplate(String ... namesAndSpecs) {
        return VirtData.getTemplate(Map.of(), namesAndSpecs);
    }

    public static BindingsTemplate getTemplate(Map<String, Object> config, List<BindPoint> bindPoints) {
        for (BindPoint bindPoint : bindPoints) {
            String bindspec = bindPoint.getBindspec();
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)bindspec);
            if (parseResult.throwable == null) continue;
            throw new RuntimeException(parseResult.throwable);
        }
        return new BindingsTemplate(config, bindPoints);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec, Map<String, ?> config) {
        flowSpec = CompatibilityFixups.fixup(flowSpec);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        VirtDataComposer composer = new VirtDataComposer();
        composer.addCustomElements(config);
        Optional<ResolvedFunction> resolvedFunction = composer.resolveFunctionFlow(flow);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec) {
        return VirtData.getOptionalMapper(flowSpec, Collections.emptyMap());
    }

    public static ResolverDiagnostics getMapperDiagnostics(String flowSpec) {
        return VirtData.getMapperDiagnostics(flowSpec, Collections.emptyMap());
    }

    public static ResolverDiagnostics getMapperDiagnostics(String flowSpec, Map<String, Object> config) {
        try {
            flowSpec = CompatibilityFixups.fixup(flowSpec);
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
            if (parseResult.throwable != null) {
                throw new RuntimeException(parseResult.throwable);
            }
            VirtDataFlow flow = parseResult.flow;
            VirtDataComposer composer = new VirtDataComposer();
            composer.addCustomElements(config);
            ResolverDiagnostics resolverDiagnostics = composer.resolveDiagnosticFunctionFlow(flow);
            return resolverDiagnostics;
        }
        catch (Exception e) {
            return new ResolverDiagnostics().error(e);
        }
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec, Class<? extends T> clazz) {
        return VirtData.getOptionalMapper(flowSpec, clazz, Collections.emptyMap());
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec, Class<?> clazz, Map<String, Object> config) {
        Object actualTestValue;
        flowSpec = CompatibilityFixups.fixup(flowSpec);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        String outputType = flow.getLastExpression().getCall().getOutputType();
        Class<?> outputClass = ValueType.classOfType(outputType);
        if (outputClass != null) {
            if (!ClassUtils.isAssignable(outputClass, clazz, (boolean)true)) {
                throw new RuntimeException("The flow specifier '" + flowSpec + "' wants an output type of '" + outputType + "', but this type is not assignable to the explicit class '" + clazz.getCanonicalName() + "' that was enforced at the API level. Either remove the output type qualifier at the last function in the flow spec, or change it to something that can reliably be cast to type '" + clazz.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning output type qualifier '->" + clazz.getCanonicalName() + "' to specifier '" + flowSpec + "'");
            flow.getLastExpression().getCall().setOutputType(clazz.getCanonicalName());
        }
        VirtDataComposer composer = new VirtDataComposer();
        composer.addCustomElements(config);
        Optional<ResolvedFunction> resolvedFunction = composer.resolveFunctionFlow(flow);
        Optional<DataMapper<T>> mapper = resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        if (mapper.isPresent() && !ClassUtils.isAssignable((actualTestValue = mapper.get().get(1L)).getClass(), clazz, (boolean)true)) {
            throw new RuntimeException("The flow specifier '" + flowSpec + "' successfully created a function, but the test value(" + actualTestValue + ") of type [" + actualTestValue.getClass() + "] produced by it was not assignable to the type '" + clazz.getCanonicalName() + "' which was explicitly set at the API level.");
        }
        return mapper;
    }

    public static <T> T getFunction(String flowSpec, Class<? extends T> functionType) {
        return VirtData.getFunction(flowSpec, functionType, Collections.emptyMap());
    }

    public static <T> T getFunction(String flowSpec, Class<? extends T> functionType, Map<String, Object> config) {
        Optional<T> optionalFunction = VirtData.getOptionalFunction(flowSpec, functionType, config);
        return optionalFunction.orElseThrow();
    }

    public static <T> Optional<T> getOptionalFunction(String flowSpec, Class<? extends T> functionType) {
        return VirtData.getOptionalFunction(flowSpec, functionType, Collections.emptyMap());
    }

    public static <T> Optional<T> getOptionalFunction(String flowSpec, Class<? extends T> functionType, Map<String, Object> config) {
        String specifiedOutputClassName;
        Class<?> specifiedOutputClass;
        flowSpec = CompatibilityFixups.fixup(flowSpec);
        Class<?> requiredInputType = FunctionTyper.getInputClass(functionType);
        Class<?> requiredOutputType = FunctionTyper.getResultClass(functionType);
        FunctionalInterface annotation = functionType.getAnnotation(FunctionalInterface.class);
        if (annotation == null) {
            throw new RuntimeException("You can only use function types that are tagged as @FunctionInterface");
        }
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        String specifiedInputClassName = flow.getFirstExpression().getCall().getInputType();
        Class<?> specifiedInputClass = ValueType.classOfType(specifiedInputClassName);
        if (specifiedInputClass != null) {
            if (!ClassUtils.isAssignable(specifiedInputClass, requiredInputType, (boolean)true)) {
                throw new RuntimeException("The flow specifier '" + flowSpec + "' wants an input type of '" + specifiedInputClassName + "', but this type is not assignable to the input class required by the functional type requested '" + functionType.getCanonicalName() + "'. (type " + requiredInputType.getCanonicalName() + ") Either remove the input type qualifier at the first function in the flow spec, or change it to something that can reliably be cast to type '" + requiredInputType.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning input type qualifier '" + requiredInputType.getCanonicalName() + "->' to specifier '" + flowSpec + "'");
            flow.getFirstExpression().getCall().setInputType(requiredInputType.getCanonicalName());
        }
        if ((specifiedOutputClass = ValueType.classOfType(specifiedOutputClassName = flow.getLastExpression().getCall().getOutputType())) != null) {
            if (!ClassUtils.isAssignable(specifiedOutputClass, requiredOutputType, (boolean)true)) {
                throw new RuntimeException("The flow specifier '" + flowSpec + "' wants an output type of '" + specifiedOutputClass + "', but this type is not assignable to the output class required by functional type '" + functionType.getCanonicalName() + "'. (type " + requiredOutputType.getCanonicalName() + ") Either remove the output type qualifier at the last function in the flow spec, or change it to something that can reliably be cast to type '" + requiredOutputType.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning output type qualifier '->" + requiredOutputType.getCanonicalName() + "' to specifier '" + flowSpec + "'");
            flow.getLastExpression().getCall().setOutputType(requiredOutputType.getCanonicalName());
        }
        VirtDataComposer composer = new VirtDataComposer();
        composer.addCustomElements(config);
        Optional<ResolvedFunction> resolvedFunction = composer.resolveFunctionFlow(flow);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(functionType::cast);
    }

    public static <T> DataMapper<T> getMapper(String flowSpec, Map<String, Object> config) {
        Optional<DataMapper<T>> optionalMapper = VirtData.getOptionalMapper(flowSpec, config);
        return optionalMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + flowSpec));
    }

    public static <T> DataMapper<T> getMapper(String flowSpec) {
        return VirtData.getMapper(flowSpec, Collections.emptyMap());
    }

    public static <T> DataMapper<T> getMapper(String flowSpec, Class<? extends T> clazz, Map<String, Object> config) {
        Optional<DataMapper<T>> dataMapper = VirtData.getOptionalMapper(flowSpec, clazz);
        DataMapper<? extends T> mapper = dataMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + flowSpec));
        return mapper;
    }

    public static <T> DataMapper<T> getMapper(String flowSpec, Class<? extends T> clazz) {
        return VirtData.getMapper(flowSpec, clazz, Collections.emptyMap());
    }
}

