/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.bindings;

import io.nosqlbench.virtdata.core.bindings.DataMapper;
import io.nosqlbench.virtdata.core.bindings.DataMapperFunctionMapper;
import io.nosqlbench.virtdata.core.bindings.ResolvedFunction;
import io.nosqlbench.virtdata.core.bindings.ValueType;
import io.nosqlbench.virtdata.lang.ast.Expression;
import io.nosqlbench.virtdata.lang.ast.FunctionCall;
import io.nosqlbench.virtdata.lang.parser.VirtDataDSL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface VirtDataFunctionLibrary {
    public List<ResolvedFunction> resolveFunctions(Class<?> var1, Class<?> var2, String var3, Map<String, ?> var4, Object ... var5);

    default public List<ResolvedFunction> resolveFunction(String spec) {
        return this.resolveFunctions(spec, new HashMap<String, Object>());
    }

    default public List<ResolvedFunction> resolveFunctions(String spec, Map<String, Object> customConfigs) {
        ArrayList<ResolvedFunction> resolvedFunctions = new ArrayList<ResolvedFunction>();
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)spec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        List expressions = parseResult.flow.getExpressions();
        if (expressions.size() > 1) {
            throw new RuntimeException("Unable to promote a lambda flow to a data mapper here.");
        }
        FunctionCall call = ((Expression)expressions.get(0)).getCall();
        List<ResolvedFunction> found = this.resolveFunctions(Optional.ofNullable(call.getOutputType()).map(ValueType::valueOfClassName).map(ValueType::getValueClass).orElse(null), Optional.ofNullable(call.getInputType()).map(ValueType::valueOfClassName).map(ValueType::getValueClass).orElse(null), call.getFunctionName(), customConfigs, call.getArguments());
        resolvedFunctions.addAll(found);
        return resolvedFunctions;
    }

    default public <T> List<DataMapper<T>> getDataMappers(String spec) {
        return this.getDataMappers(spec, new HashMap<String, Object>());
    }

    default public <T> List<DataMapper<T>> getDataMappers(String spec, Map<String, Object> customConfigs) {
        List<ResolvedFunction> resolvedFunctions1 = this.resolveFunctions(spec, customConfigs);
        return resolvedFunctions1.stream().map(r -> DataMapperFunctionMapper.map(r.getFunctionObject())).collect(Collectors.toList());
    }

    default public <T> Optional<DataMapper<T>> getDataMapper(String spec) {
        return this.getDataMapper(spec, new HashMap<String, Object>());
    }

    default public <T> Optional<DataMapper<T>> getDataMapper(String spec, Map<String, Object> customConfigs) {
        List<ResolvedFunction> resolvedFunctions = this.resolveFunctions(spec, customConfigs);
        switch (resolvedFunctions.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(DataMapperFunctionMapper.map(resolvedFunctions.get(0).getFunctionObject()));
            }
        }
        throw new RuntimeException("Found " + resolvedFunctions.size() + " data mapping functions, expected exactly one for library-level function lookups. This may require both an input and an output type qualifier like 'int -> f() -> int'. \nFound: [<library name>::] input->class->output [initializer type->parameter type,...]: \n" + resolvedFunctions.stream().map(String::valueOf).collect(Collectors.joining("\n")));
    }
}

