/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import java.util.Objects;

public class BindPoint {
    private final String anchor;
    private final String bindspec;
    private final Type type;

    public BindPoint(String anchor, String bindspec, Type type) {
        this.anchor = anchor;
        this.bindspec = bindspec;
        this.type = type;
    }

    public BindPoint(String anchor, String bindspec) {
        this.anchor = anchor;
        this.bindspec = bindspec;
        this.type = Type.reference;
    }

    public static BindPoint of(String userid, String bindspec, Type type) {
        return new BindPoint(userid, bindspec, type);
    }

    public Type getType() {
        return this.type;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String getBindspec() {
        return this.bindspec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindPoint bindPoint = (BindPoint)o;
        return Objects.equals(this.anchor, bindPoint.anchor) && Objects.equals(this.bindspec, bindPoint.bindspec) && this.type == bindPoint.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.anchor, this.bindspec, this.type});
    }

    public String toString() {
        return "BindPoint{anchor='" + this.anchor + "', bindspec='" + this.bindspec + "', type=" + this.type + "}";
    }

    public static enum Type {
        reference,
        definition;

    }
}

