/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.core.templates.BindPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BindPointParser
implements BiFunction<String, Map<String, String>, Result> {
    public static final Pattern BINDPOINT_ANCHOR = Pattern.compile("(\\{((?<anchor>\\w+[-_\\d\\w.]*)})|(\\{\\{(?<extended>[^}]+?)}}))");
    public static final String DEFINITION = "DEFINITION";

    @Override
    public Result apply(String template, Map<String, String> bindings) {
        Matcher m = BINDPOINT_ANCHOR.matcher(template);
        int lastMatch = 0;
        ArrayList<String> spans = new ArrayList<String>();
        ArrayList<BindPoint> bindpoints = new ArrayList<BindPoint>();
        while (m.find()) {
            String pre = template.substring(lastMatch, m.start());
            spans.add(pre);
            lastMatch = m.end();
            String anchor = m.group("anchor");
            String extendedAnchor = m.group("extended");
            if (anchor != null) {
                bindpoints.add(BindPoint.of(anchor, bindings.getOrDefault(anchor, null), BindPoint.Type.reference));
                spans.add(anchor);
                continue;
            }
            if (extendedAnchor != null) {
                bindpoints.add(BindPoint.of(DEFINITION, extendedAnchor, BindPoint.Type.definition));
                spans.add(extendedAnchor);
                continue;
            }
            throw new BasicError("Unable to parse: " + template);
        }
        spans.add(lastMatch >= 0 ? template.substring(lastMatch) : template);
        return new Result(spans, bindpoints);
    }

    public static final class Result {
        private final List<String> spans;
        private final List<BindPoint> bindpoints;

        public Result(List<String> spans, List<BindPoint> bindpoints) {
            this.spans = spans;
            this.bindpoints = bindpoints;
        }

        public List<String> getSpans() {
            return this.spans;
        }

        public List<BindPoint> getBindpoints() {
            return this.bindpoints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.spans, result.spans) && Objects.equals(this.bindpoints, result.bindpoints);
        }

        public int hashCode() {
            return Objects.hash(this.spans, this.bindpoints);
        }

        public String toString() {
            return "Result{spans=" + this.spans + ", bindpoints=" + this.bindpoints + "}";
        }
    }
}

