/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import java.util.Objects;

public class CapturePoint {
    private final String name;
    private final String asName;

    public CapturePoint(String name, String asName) {
        this.name = name;
        this.asName = asName;
    }

    public String getName() {
        return this.name;
    }

    public static CapturePoint of(String anchorName, String aliasName) {
        Objects.requireNonNull(anchorName);
        return new CapturePoint(anchorName, aliasName == null ? anchorName : aliasName);
    }

    public static CapturePoint of(String anchorName) {
        Objects.requireNonNull(anchorName);
        return new CapturePoint(anchorName, anchorName);
    }

    public String toString() {
        return "[" + this.getName() + (String)(this.name.equals(this.asName) ? "" : " as " + this.asName) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapturePoint that = (CapturePoint)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.asName, that.asName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.asName);
    }
}

