/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import io.nosqlbench.virtdata.core.templates.CapturePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CapturePointParser
implements Function<String, Result> {
    public static final Pattern CAPTUREPOINT_PATTERN = Pattern.compile("(\\[(?<capture>\\w+[-_\\d\\w.]*)(\\s+[aA][sS]\\s+(?<alias>\\w+[-_\\d\\w.]*))?])");

    @Override
    public Result apply(String template) {
        StringBuilder raw = new StringBuilder();
        Matcher m = CAPTUREPOINT_PATTERN.matcher(template);
        ArrayList<CapturePoint> captures = new ArrayList<CapturePoint>();
        while (m.find()) {
            CapturePoint captured = CapturePoint.of(m.group("capture"), m.group("alias"));
            captures.add(captured);
            m.appendReplacement(raw, captured.getName());
        }
        m.appendTail(raw);
        return new Result(raw.toString(), captures);
    }

    public static final class Result {
        private final String rawTemplate;
        private final List<CapturePoint> captures;

        public Result(String rawTemplate, List<CapturePoint> captures) {
            this.rawTemplate = rawTemplate;
            this.captures = captures;
        }

        public String getRawTemplate() {
            return this.rawTemplate;
        }

        public List<CapturePoint> getCaptures() {
            return this.captures;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.rawTemplate, result.rawTemplate) && Objects.equals(this.captures, result.captures);
        }

        public int hashCode() {
            return Objects.hash(this.rawTemplate, this.captures);
        }

        public String toString() {
            return "Result{rawTemplate='" + this.rawTemplate + "', captures=" + this.captures + "}";
        }
    }
}

